/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.sql.callback;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import org.nutz.dao.DaoException;
import org.nutz.dao.pager.ResultSetLooping;
import org.nutz.dao.sql.Sql;
import org.nutz.dao.sql.SqlCallback;
import org.nutz.dao.sql.SqlContext;
import org.nutz.lang.Streams;

public class QueryMapCallback
implements SqlCallback {
    public static final SqlCallback me = new QueryMapCallback();

    @Override
    public Object invoke(Connection conn, ResultSet rs, Sql sql) throws SQLException {
        final ResultSetMetaData meta = rs.getMetaData();
        final int count = meta.getColumnCount();
        ResultSetLooping ing = new ResultSetLooping(){

            @Override
            protected boolean createObject(int index, ResultSet rs, SqlContext context, int rowCout) {
                String name = null;
                int i = 0;
                try {
                    LinkedHashMap<String, Object> re = new LinkedHashMap<String, Object>();
                    i = 1;
                    while (i <= count) {
                        name = meta.getColumnLabel(i);
                        switch (meta.getColumnType(i)) {
                            case 93: {
                                re.put(name, rs.getTimestamp(i));
                                break;
                            }
                            case 91: {
                                re.put(name, rs.getTimestamp(i));
                                break;
                            }
                            case 2005: {
                                re.put(name, Streams.read(rs.getCharacterStream(i)).toString());
                                break;
                            }
                            default: {
                                re.put(name, rs.getObject(i));
                            }
                        }
                        ++i;
                    }
                    this.list.add(re);
                    return true;
                }
                catch (Exception e) {
                    if (name != null) {
                        throw new DaoException(String.format("Column Name=%s, index=%d", name, i), e);
                    }
                    throw new DaoException(e);
                }
            }
        };
        ing.doLoop(rs, sql.getContext());
        return ing.getList();
    }
}

