/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.sql.pojo;

import org.nutz.dao.Chain;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.impl.sql.pojo.AbstractPItem;
import org.nutz.dao.jdbc.ValueAdaptor;
import org.nutz.lang.Lang;

public class InsertByChainPItem
extends AbstractPItem {
    private String[] names;
    private Object[] values;

    public InsertByChainPItem(Chain chain) {
        this.names = new String[chain.size()];
        this.values = new Object[chain.size()];
        Chain c = chain.head();
        int i = 0;
        while (c != null) {
            this.names[i] = c.name();
            this.values[i] = c.value();
            ++i;
            c = c.next();
        }
        if (i == 0) {
            throw Lang.makeThrow("Insert empty chain!", new Object[0]);
        }
    }

    @Override
    public void joinSql(Entity<?> en, StringBuilder sb) {
        sb.append(" (").append(this._colname(en, 0));
        int i = 1;
        while (i < this.names.length) {
            sb.append(',').append(this._colname(en, i));
            ++i;
        }
        sb.append(") VALUES(?");
        i = 1;
        while (i < this.names.length) {
            sb.append(",?");
            ++i;
        }
        sb.append(')');
    }

    @Override
    public int joinAdaptor(Entity<?> en, ValueAdaptor[] adaptors, int off) {
        int i = 0;
        while (i < this.names.length) {
            adaptors[off++] = en.getColumn(this._colname(en, i)).getAdaptor();
            ++i;
        }
        return off;
    }

    @Override
    public int joinParams(Entity<?> en, Object obj, Object[] params, int off) {
        int i = 0;
        while (i < this.values.length) {
            params[off++] = this.values[i];
            ++i;
        }
        return off;
    }

    @Override
    public int paramCount(Entity<?> en) {
        return this.values.length;
    }

    private String _colname(Entity<?> en, int index) {
        MappingField field = en.getField(this.names[index]);
        if (field == null) {
            throw new IllegalArgumentException(String.format("Class %s didn't have field named (%s)", en.getType(), this.names[index]));
        }
        return field.getColumnName();
    }
}

