/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.sql.pojo;

import org.nutz.castor.Castors;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.impl.sql.pojo.AbstractPItem;
import org.nutz.dao.jdbc.ValueAdaptor;
import org.nutz.lang.Lang;

public class SingleColumnCondtionPItem
extends AbstractPItem {
    private ValueAdaptor va;
    private Object def;
    private String colName;
    private Class<?> colType;
    private MappingField mf;
    private boolean casesensitive;

    public SingleColumnCondtionPItem(MappingField mf, Object def) {
        this.mf = mf;
        this.va = mf.getAdaptor();
        this.colName = mf.getColumnName();
        this.colType = mf.getTypeClass();
        this.def = def;
    }

    public SingleColumnCondtionPItem(String colName, Class<?> colType, ValueAdaptor va, Object def) {
        this.colName = colName;
        this.colType = colType;
        this.va = va;
        this.def = def;
    }

    @Override
    public int joinParams(Entity<?> en, Object obj, Object[] params, int off) {
        if (this.def == obj && obj != null) {
            params[off++] = this.def;
        } else {
            en = this._en(en);
            if (obj != null && this.mf != null && this.mf.getEntity() == en && en.getType().isInstance(obj)) {
                params[off++] = this.mf.getValue(obj);
            } else if (this.def != null) {
                params[off++] = this.def;
            } else if (obj != null) {
                params[off++] = Castors.me().castTo(obj, this.colType);
            } else {
                throw Lang.impossible();
            }
        }
        return off;
    }

    @Override
    public void joinSql(Entity<?> en, StringBuilder sb) {
        if (this.mf != null && !this.casesensitive) {
            switch (this.mf.getColumnType()) {
                case CHAR: 
                case VARCHAR: 
                case TEXT: {
                    sb.append(" WHERE LOWER(").append(this.colName).append(")=LOWER(?)");
                    return;
                }
            }
        }
        sb.append(" WHERE ").append(this.colName).append("=?");
    }

    @Override
    public int joinAdaptor(Entity<?> en, ValueAdaptor[] adaptors, int off) {
        adaptors[off++] = this.va;
        return off;
    }

    @Override
    public int paramCount(Entity<?> en) {
        return 1;
    }

    public SingleColumnCondtionPItem setCasesensitive(boolean casesensitive) {
        this.casesensitive = casesensitive;
        return this;
    }
}

