/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.sql.pojo;

import org.nutz.dao.Chain;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.impl.sql.pojo.AbstractPItem;
import org.nutz.dao.jdbc.Jdbcs;
import org.nutz.dao.jdbc.ValueAdaptor;
import org.nutz.lang.Lang;

public class UpdateFieldsByChainPItem
extends AbstractPItem {
    private Chain chain;

    public UpdateFieldsByChainPItem(Chain chain) {
        this.chain = chain;
    }

    @Override
    public void joinSql(Entity<?> en, StringBuilder sb) {
        if (this.chain.size() > 0) {
            sb.append(" SET ");
            Chain c = this.chain.head();
            while (c != null) {
                sb.append(this._fmtcolnm(en, c.name()));
                sb.append("=? ,");
                c = c.next();
            }
        } else {
            throw Lang.makeThrow("Entity chain for UPDATE '%s'", en.getType().getName());
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(' ');
    }

    @Override
    public int joinAdaptor(Entity<?> en, ValueAdaptor[] adaptors, int off) {
        Chain c = this.chain.head();
        while (c != null) {
            MappingField mf = en.getField(c.name());
            if (c.adaptor() == null) {
                adaptors[off++] = mf == null ? Jdbcs.getAdaptorBy(c.value()) : mf.getAdaptor();
            } else {
                adaptors[off++] = c.adaptor();
            }
            c = c.next();
        }
        return off;
    }

    @Override
    public int joinParams(Entity<?> en, Object obj, Object[] params, int off) {
        Chain c = this.chain.head();
        while (c != null) {
            params[off++] = c.value();
            c = c.next();
        }
        return off;
    }

    @Override
    public int paramCount(Entity<?> en) {
        return this.chain.size();
    }
}

