/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.sql.run;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.nutz.dao.DaoException;
import org.nutz.dao.impl.DaoExecutor;
import org.nutz.dao.jdbc.ValueAdaptor;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.sql.DaoStatement;
import org.nutz.dao.sql.SqlType;
import org.nutz.dao.util.Daos;
import org.nutz.lang.Lang;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class NutDaoExecutor
implements DaoExecutor {
    private static final Log log = Logs.get();

    @Override
    public void exec(Connection conn, DaoStatement st) {
        try {
            st.onBefore(conn);
            switch (st.getSqlType()) {
                case SELECT: {
                    this._runSelect(conn, st);
                    break;
                }
                case TRUNCATE: 
                case CREATE: 
                case DROP: 
                case ALTER: {
                    this._runStatement(conn, st);
                    st.onAfter(conn, null);
                    break;
                }
                case RUN: {
                    st.onAfter(conn, null);
                    break;
                }
                case EXEC: 
                case CALL: {
                    this._runExec(conn, st);
                    break;
                }
                default: {
                    Object[][] paramMatrix;
                    if (st.getSqlType() == SqlType.OTHER && log.isInfoEnabled()) {
                        log.info("Can't indentify SQL type :   " + st);
                    }
                    if ((paramMatrix = st.getParamMatrix()) == null || paramMatrix.length == 0) {
                        this._runStatement(conn, st);
                    } else {
                        this._runPreparedStatement(conn, st, paramMatrix);
                    }
                    st.onAfter(conn, null);
                    break;
                }
            }
        }
        catch (SQLException e) {
            if (log.isDebugEnabled()) {
                log.debug("SQLException", e);
                SQLException nextException = e.getNextException();
                if (e != null) {
                    log.debug("SQL NextException", nextException);
                }
            }
            throw new DaoException(String.format("!Nutz SQL Error: '%s'\nPreparedStatement: \n'%s'", st.toString(), st.toPreparedStatement()), e);
        }
    }

    protected void _runExec(Connection conn, DaoStatement st) throws SQLException {
        block17: {
            if (st.getContext().getPager() != null) {
                throw Lang.makeThrow(DaoException.class, "NOT Pageable : " + st, new Object[0]);
            }
            String sql = st.toPreparedStatement();
            if (log.isDebugEnabled()) {
                log.debug(sql);
            }
            Object[][] paramMatrix = st.getParamMatrix();
            CallableStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = conn.prepareCall(sql);
                ValueAdaptor[] adaptors = st.getAdaptors();
                if (paramMatrix != null && paramMatrix.length > 0) {
                    int i = 0;
                    while (i < paramMatrix[0].length) {
                        adaptors[i].set(stmt, paramMatrix[0][i], i + 1);
                        ++i;
                    }
                }
                stmt.execute();
                rs = stmt.getResultSet();
                try {
                    st.onAfter(conn, rs);
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
                if (!stmt.getMoreResults()) break block17;
                rs = stmt.getResultSet();
                try {
                    if (rs != null) {
                        st.onAfter(conn, rs);
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                stmt.close();
            }
        }
    }

    private void _runSelect(Connection conn, DaoStatement st) throws SQLException {
        Pager pager;
        Object[][] paramMatrix = st.getParamMatrix();
        int startRow = -1;
        int lastRow = -1;
        if (st.getContext().getResultSetType() == 1004 && (pager = st.getContext().getPager()) != null) {
            startRow = pager.getOffset();
            lastRow = pager.getOffset() + pager.getPageSize();
        }
        String sql = st.toPreparedStatement();
        ResultSet rs = null;
        Statement stat = null;
        try {
            if (paramMatrix == null || paramMatrix.length == 0 || paramMatrix[0].length == 0) {
                if (log.isDebugEnabled()) {
                    log.debug(st);
                }
                stat = conn.createStatement(st.getContext().getResultSetType(), 1007);
                if (lastRow > 0) {
                    stat.setMaxRows(lastRow);
                }
                if (st.getContext().getFetchSize() != 0) {
                    stat.setFetchSize(st.getContext().getFetchSize());
                }
                rs = stat.executeQuery(sql);
            } else {
                if (paramMatrix.length > 1 && log.isWarnEnabled()) {
                    log.warnf("Drop last %d rows parameters for:\n%s", paramMatrix.length - 1, st);
                }
                if (log.isDebugEnabled()) {
                    log.debug(st);
                }
                ValueAdaptor[] adaptors = st.getAdaptors();
                stat = conn.prepareStatement(sql, st.getContext().getResultSetType(), 1007);
                if (lastRow > 0) {
                    stat.setMaxRows(lastRow);
                }
                if (st.getContext().getFetchSize() != 0) {
                    stat.setFetchSize(st.getContext().getFetchSize());
                }
                int i = 0;
                while (i < paramMatrix[0].length) {
                    adaptors[i].set((PreparedStatement)stat, paramMatrix[0][i], i + 1);
                    ++i;
                }
                rs = ((PreparedStatement)stat).executeQuery();
            }
            if (startRow > 0) {
                rs.absolute(startRow);
            }
            st.onAfter(conn, rs);
        }
        catch (Throwable throwable) {
            Daos.safeClose(stat, rs);
            throw throwable;
        }
        Daos.safeClose(stat, rs);
        if (log.isTraceEnabled()) {
            log.trace("...DONE");
        }
    }

    private void _runPreparedStatement(Connection conn, DaoStatement st, Object[][] paramMatrix) throws SQLException {
        ValueAdaptor[] adaptors = st.getAdaptors();
        if (adaptors.length != paramMatrix[0].length) {
            throw Lang.makeThrow("DaoStatement adaptor MUST same width with param matrix.", new Object[0]);
        }
        boolean statIsClosed = false;
        String sql = st.toPreparedStatement();
        PreparedStatement pstat = null;
        if (log.isDebugEnabled()) {
            log.debug(st);
        }
        try {
            pstat = conn.prepareStatement(sql);
            if (paramMatrix.length == 1) {
                int i = 0;
                while (i < paramMatrix[0].length) {
                    adaptors[i].set(pstat, paramMatrix[0][i], i + 1);
                    ++i;
                }
                pstat.execute();
                st.getContext().setUpdateCount(pstat.getUpdateCount());
                pstat.close();
                statIsClosed = true;
            } else {
                Object[][] objectArray = paramMatrix;
                int n = paramMatrix.length;
                int n2 = 0;
                while (n2 < n) {
                    Object[] params = objectArray[n2];
                    int i = 0;
                    while (i < params.length) {
                        adaptors[i].set(pstat, params[i], i + 1);
                        ++i;
                    }
                    pstat.addBatch();
                    ++n2;
                }
                int[] counts = pstat.executeBatch();
                int sum = 0;
                int[] nArray = counts;
                int n3 = counts.length;
                int n4 = 0;
                while (n4 < n3) {
                    int i = nArray[n4];
                    if (i > 0) {
                        sum += i;
                    }
                    ++n4;
                }
                if (sum == 0) {
                    sum = pstat.getUpdateCount();
                }
                pstat.close();
                statIsClosed = true;
                st.getContext().setUpdateCount(sum);
            }
        }
        finally {
            if (!statIsClosed) {
                Daos.safeClose(pstat);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("...DONE");
        }
    }

    private void _runStatement(Connection conn, DaoStatement st) throws SQLException {
        boolean statIsClosed = false;
        Statement stat = null;
        String sql = st.toPreparedStatement();
        if (log.isDebugEnabled()) {
            log.debug(sql);
        }
        try {
            stat = conn.createStatement();
            stat.execute(sql);
            st.getContext().setUpdateCount(stat.getUpdateCount());
            stat.close();
            statIsClosed = true;
        }
        finally {
            if (!statIsClosed) {
                Daos.safeClose(stat);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("...DONE");
        }
    }
}

