/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.jdbc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.nutz.dao.DaoException;
import org.nutz.dao.jdbc.JdbcExpert;
import org.nutz.filepool.FilePool;
import org.nutz.filepool.NutFilePool;
import org.nutz.filepool.SynchronizedFilePool;
import org.nutz.lang.Mirror;
import org.nutz.lang.util.Disks;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class JdbcExpertConfigFile {
    private Map<String, Class<? extends JdbcExpert>> experts;
    private Map<Pattern, Class<? extends JdbcExpert>> _experts;
    private Map<String, Object> config;
    private FilePool pool;
    private static final Log log = Logs.get();

    JdbcExpertConfigFile init() {
        block3: {
            String home = this.config.get("pool-home").toString();
            try {
                home = Disks.normalize(home);
                if (home == null) {
                    home = this.config.get("pool-home").toString();
                }
                long max = this.config.containsKey("pool-max") ? ((Number)this.config.get("pool-max")).longValue() : 2000L;
                this.pool = new NutFilePool(home, max);
                this.pool = new SynchronizedFilePool(this.pool);
            }
            catch (Throwable e) {
                if (!log.isWarnEnabled()) break block3;
                log.warnf("NutDao FilePool create fail!! Blob and Clob Support is DISABLE!! Home=" + home, e);
            }
        }
        return this;
    }

    public JdbcExpert getExpert(String str) {
        Class<? extends JdbcExpert> type = this.experts.get(str);
        return (JdbcExpert)((Object)Mirror.me(type).born(this.config));
    }

    public JdbcExpert matchExpert(String dbName) {
        for (Map.Entry<Pattern, Class<? extends JdbcExpert>> entry : this._experts.entrySet()) {
            if (!entry.getKey().matcher(dbName).find()) continue;
            return (JdbcExpert)((Object)Mirror.me(entry.getValue()).born(this));
        }
        return null;
    }

    public Map<String, Class<? extends JdbcExpert>> getExperts() {
        return Collections.unmodifiableMap(this.experts);
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public FilePool getPool() {
        if (this.pool == null) {
            if (log.isWarnEnabled()) {
                log.warnf("NutDao FilePool create fail!! Blob and Clob Support is DISABLE!!", new Object[0]);
            }
            throw new DaoException("NutDao FilePool create fail!! Blob and Clob Support is DISABLE!!");
        }
        return this.pool;
    }

    public void setExperts(Map<String, Class<? extends JdbcExpert>> experts) {
        this.experts = experts;
        this._experts = new HashMap<Pattern, Class<? extends JdbcExpert>>();
        for (Map.Entry<String, Class<? extends JdbcExpert>> entry : experts.entrySet()) {
            this._experts.put(Pattern.compile(entry.getKey(), 0), entry.getValue());
        }
    }

    public void setConfig(Map<String, Object> config) {
        this.config = config;
    }
}

