/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.util.cri;

import org.nutz.dao.entity.Entity;
import org.nutz.dao.jdbc.Jdbcs;
import org.nutz.dao.jdbc.ValueAdaptor;
import org.nutz.dao.util.cri.AbstractSqlExpression;

public class NameRange
extends AbstractSqlExpression {
    private String[] names;

    NameRange(String name, String ... names) {
        super(name);
        this.names = names;
        this.not = false;
    }

    @Override
    public void joinSql(Entity<?> en, StringBuilder sb) {
        if (this.names.length > 0) {
            sb.append(this._fmtcol(en));
            if (this.not) {
                sb.append(" NOT");
            }
            sb.append(" IN (");
            int i = 0;
            while (i < this.names.length) {
                sb.append("?,");
                ++i;
            }
            sb.setCharAt(sb.length() - 1, ')');
        }
    }

    @Override
    public int joinAdaptor(Entity<?> en, ValueAdaptor[] adaptors, int off) {
        int i = 0;
        while (i < this.names.length) {
            adaptors[off++] = Jdbcs.Adaptor.asString;
            ++i;
        }
        return off;
    }

    @Override
    public int joinParams(Entity<?> en, Object obj, Object[] params, int off) {
        String[] stringArray = this.names;
        int n = this.names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            params[off++] = name;
            ++n2;
        }
        return off;
    }

    @Override
    public int paramCount(Entity<?> en) {
        return this.names.length;
    }
}

