/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.http;

import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.nutz.http.ProxySwitcher;
import org.nutz.http.Request;
import org.nutz.http.Response;
import org.nutz.http.Sender;
import org.nutz.lang.Encoding;
import org.nutz.lang.Lang;

public class Http {
    public static ProxySwitcher proxySwitcher;

    public static Response get(String url) {
        return Sender.create(Request.get(url)).send();
    }

    public static Response get(String url, int timeout) {
        return Sender.create(Request.get(url)).setTimeout(timeout).send();
    }

    public static String post(String url, Map<String, Object> params, int timeout) {
        return Sender.create(Request.create(url, Request.METHOD.POST, params, null)).setTimeout(timeout).send().getContent();
    }

    public static Response post2(String url, Map<String, Object> params, int timeout) {
        return Sender.create(Request.create(url, Request.METHOD.POST, params, null)).setTimeout(timeout).send();
    }

    public static String encode(Object s) {
        if (s == null) {
            return "";
        }
        try {
            return URLEncoder.encode(s.toString(), Encoding.CHARSET_UTF8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public static String post(String url, Map<String, Object> params, String inenc, String reenc) {
        return Sender.create(Request.create(url, Request.METHOD.POST, params, null).setEnc(inenc)).send().getContent(reenc);
    }

    public static void setHttpProxy(String host, int port) {
        final Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
        proxySwitcher = new ProxySwitcher(){

            @Override
            public Proxy getProxy(URL url) {
                return proxy;
            }

            @Override
            public Proxy getProxy(Request req) {
                req.getHeader().set("Connection", "close");
                return this.getProxy(req.getUrl());
            }
        };
    }

    public static void setSocktProxy(String host, int port) {
        final Proxy proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(host, port));
        proxySwitcher = new ProxySwitcher(){

            @Override
            public Proxy getProxy(URL url) {
                return proxy;
            }

            @Override
            public Proxy getProxy(Request req) {
                req.getHeader().set("Connection", "close");
                return this.getProxy(req.getUrl());
            }
        };
    }

    public static ProxySwitcher getProxySwitcher() {
        return proxySwitcher;
    }

    public static void setProxySwitcher(ProxySwitcher proxySwitcher) {
        Http.proxySwitcher = proxySwitcher;
    }

    public static class multipart {
        public static String getBoundary(String contentType) {
            if (contentType == null) {
                return null;
            }
            int pos = contentType.indexOf(";");
            if (pos <= 10) {
                return null;
            }
            if (!contentType.substring(0, pos).equalsIgnoreCase("multipart/form-data")) {
                return null;
            }
            if ((pos = contentType.indexOf("=", pos)) < 0) {
                return null;
            }
            return contentType.substring(pos + 1);
        }

        public static String formatName(String name, String filename, String contentType) {
            StringBuilder sb = new StringBuilder();
            sb.append("Content-Disposition: form-data; name=\"");
            sb.append(name);
            sb.append("\"");
            if (filename != null) {
                sb.append("; filename=\"" + filename + "\"");
            }
            if (contentType != null) {
                sb.append("\nContent-Type: " + contentType);
            }
            sb.append(20);
            return sb.toString();
        }

        public static String formatName(String name) {
            return multipart.formatName(name, null, null);
        }
    }
}

