/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.http;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.nutz.http.Header;
import org.nutz.http.Http;
import org.nutz.http.HttpException;
import org.nutz.http.ProxySwitcher;
import org.nutz.http.Request;
import org.nutz.http.Response;
import org.nutz.http.sender.GetSender;
import org.nutz.http.sender.PostSender;
import org.nutz.lang.stream.NullInputStream;

public abstract class Sender {
    public static int Default_Conn_Timeout = 30000;
    public static int Default_Read_Timeout = 600000;
    protected Request request;
    protected int timeout;
    protected HttpURLConnection conn;

    public static Sender create(String url) {
        return Sender.create(Request.get(url));
    }

    public static Sender create(String url, int timeout) {
        return Sender.create(Request.get(url)).setTimeout(timeout);
    }

    public static Sender create(Request request) {
        return request.isGet() ? new GetSender(request) : new PostSender(request);
    }

    public static Sender create(Request request, int timeout) {
        Sender sender = request.isGet() ? new GetSender(request) : new PostSender(request);
        return sender.setTimeout(timeout);
    }

    protected Sender(Request request) {
        this.request = request;
    }

    public abstract Response send() throws HttpException;

    protected Response createResponse(Map<String, String> reHeaders) throws IOException {
        Response rep = null;
        if (reHeaders != null) {
            rep = new Response(this.conn, reHeaders);
            if (rep.isOK()) {
                InputStream is1 = this.conn.getInputStream();
                InputStream is2 = null;
                String encoding = this.conn.getContentEncoding();
                is2 = encoding != null && encoding.contains("gzip") ? new GZIPInputStream(is1) : (encoding != null && encoding.contains("deflate") ? new InflaterInputStream(is1) : is1);
                BufferedInputStream is = new BufferedInputStream(is2);
                rep.setStream(is);
            } else {
                try {
                    rep.setStream(this.conn.getInputStream());
                }
                catch (IOException iOException) {
                    rep.setStream(new NullInputStream());
                }
            }
        }
        return rep;
    }

    protected Map<String, String> getResponseHeader() throws IOException {
        if (this.conn.getResponseCode() < 0) {
            throw new IOException("Network error!! resp code < 0");
        }
        HashMap<String, String> reHeaders = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> en : this.conn.getHeaderFields().entrySet()) {
            List<String> val = en.getValue();
            if (val == null || val.size() <= 0) continue;
            reHeaders.put(en.getKey(), en.getValue().get(0));
        }
        return reHeaders;
    }

    protected void setupDoInputOutputFlag() {
        this.conn.setDoInput(true);
        this.conn.setDoOutput(true);
    }

    protected void openConnection() throws IOException {
        Proxy proxy;
        ProxySwitcher proxySwitcher = Http.proxySwitcher;
        if (proxySwitcher != null && (proxy = proxySwitcher.getProxy(this.request)) != null) {
            this.conn = (HttpURLConnection)this.request.getUrl().openConnection(proxy);
            this.conn.setConnectTimeout(Default_Conn_Timeout);
            if (this.timeout > 0) {
                this.conn.setReadTimeout(this.timeout);
            } else {
                this.conn.setReadTimeout(Default_Read_Timeout);
            }
            return;
        }
        this.conn = (HttpURLConnection)this.request.getUrl().openConnection();
        this.conn.setConnectTimeout(Default_Conn_Timeout);
        if (this.timeout > 0) {
            this.conn.setReadTimeout(this.timeout);
        } else {
            this.conn.setReadTimeout(Default_Read_Timeout);
        }
    }

    protected void setupRequestHeader() {
        URL url = this.request.getUrl();
        String host = url.getHost();
        if (url.getPort() > 0 && url.getPort() != 80) {
            host = String.valueOf(host) + ":" + url.getPort();
        }
        this.conn.setRequestProperty("Host", host);
        Header header = this.request.getHeader();
        if (header != null) {
            for (Map.Entry<String, String> entry : header.getAll()) {
                this.conn.addRequestProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    public Sender setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }
}

