/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.http.sender;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.nutz.http.HttpException;
import org.nutz.http.Request;
import org.nutz.http.Response;
import org.nutz.http.sender.PostSender;
import org.nutz.lang.Files;
import org.nutz.lang.Streams;

public class FilePostSender
extends PostSender {
    public static final String SEPARATOR = "\r\n";

    public FilePostSender(Request request) {
        super(request);
    }

    @Override
    public Response send() throws HttpException {
        try {
            String boundary = "---------------------------[Nutz]7d91571440efc";
            this.openConnection();
            this.setupRequestHeader();
            this.conn.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + boundary);
            this.setupDoInputOutputFlag();
            Map<String, Object> params = this.request.getParams();
            if (params != null && params.size() > 0) {
                DataOutputStream outs = new DataOutputStream(this.conn.getOutputStream());
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    outs.writeBytes("--" + boundary + SEPARATOR);
                    String key = entry.getKey();
                    File f = null;
                    if (entry.getValue() instanceof File) {
                        f = (File)entry.getValue();
                    } else if (entry.getValue() instanceof String) {
                        f = Files.findFile(entry.getValue().toString());
                    }
                    if (f != null && f.exists()) {
                        int amountRead;
                        outs.writeBytes("Content-Disposition:    form-data;    name=\"" + key + "\";    filename=\"" + entry.getValue() + "\"\r\n");
                        outs.writeBytes("Content-Type:   application/octet-stream\r\n\r\n");
                        if (f.length() == 0L) continue;
                        InputStream is = Streams.fileIn(f);
                        byte[] buffer = new byte[8192];
                        while ((amountRead = is.read(buffer)) != -1) {
                            outs.write(buffer, 0, amountRead);
                        }
                        outs.writeBytes(SEPARATOR);
                        Streams.safeClose(is);
                        continue;
                    }
                    outs.writeBytes("Content-Disposition:    form-data;    name=\"" + key + "\"\r\n\r\n");
                    outs.writeBytes(entry.getValue() + SEPARATOR);
                }
                outs.writeBytes("--" + boundary + "--" + SEPARATOR);
                Streams.safeFlush(outs);
                Streams.safeClose(outs);
            }
            return this.createResponse(this.getResponseHeader());
        }
        catch (IOException e) {
            throw new HttpException(this.request.getUrl().toString(), e);
        }
    }
}

