/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc;

import java.util.Map;
import org.nutz.ioc.meta.IocEventSet;
import org.nutz.ioc.meta.IocField;
import org.nutz.ioc.meta.IocObject;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.meta.Pair;

public abstract class Iocs {
    private static final String OBJFIELDS = "^(type|scope|singleton|fields|args|events)$";

    public static boolean isIocObject(Map<String, ?> map) {
        for (Map.Entry<String, ?> en : map.entrySet()) {
            if (en.getKey().matches(OBJFIELDS)) continue;
            return false;
        }
        return true;
    }

    public static Pair<Class<?>> parseName(String name) {
        String _name = null;
        Class<?> type = null;
        int pos = name.indexOf(58);
        if (pos < 0) {
            _name = Strings.trim(name);
        } else {
            _name = Strings.trim(name.substring(0, pos));
            try {
                String typeName = Strings.trim(name.substring(pos + 1));
                type = Lang.loadClass(typeName);
            }
            catch (ClassNotFoundException e) {
                throw Lang.wrapThrow(e);
            }
        }
        return new Pair<Object>(_name, type);
    }

    public static IocObject mergeWith(IocObject me, IocObject it) {
        if (me.getType() == null) {
            me.setType(it.getType());
        }
        if (me.getEvents() == null) {
            me.setEvents(it.getEvents());
        } else if (it.getEvents() != null) {
            IocEventSet eventSet = it.getEvents();
            IocEventSet myEventSet = me.getEvents();
            if (Strings.isBlank(myEventSet.getCreate())) {
                myEventSet.setCreate(eventSet.getCreate());
            }
            if (Strings.isBlank(myEventSet.getDepose())) {
                myEventSet.setDepose(eventSet.getDepose());
            }
            if (Strings.isBlank(myEventSet.getFetch())) {
                myEventSet.setFetch(eventSet.getFetch());
            }
        }
        if (Strings.isBlank(me.getScope())) {
            me.setScope(it.getScope());
        }
        if (!me.hasArgs()) {
            me.copyArgys(it.getArgs());
        }
        IocField[] iocFieldArray = it.getFields();
        int n = iocFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IocField fld = iocFieldArray[n2];
            if (!me.hasField(fld.getName())) {
                me.addField(fld);
            }
            ++n2;
        }
        return me;
    }
}

