/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc;

import org.nutz.ioc.IocEventTrigger;
import org.nutz.ioc.IocMaking;
import org.nutz.ioc.ObjectWeaver;
import org.nutz.lang.Lang;

public class ObjectProxy {
    private ObjectWeaver weaver;
    private Object obj;
    private IocEventTrigger<Object> fetch;
    private IocEventTrigger<Object> depose;

    public ObjectProxy() {
    }

    public ObjectProxy(Object obj) {
        this.obj = obj;
    }

    public ObjectProxy setWeaver(ObjectWeaver weaver) {
        this.weaver = weaver;
        return this;
    }

    public ObjectProxy setObj(Object obj) {
        this.obj = obj;
        return this;
    }

    public ObjectProxy setFetch(IocEventTrigger<Object> fetch) {
        this.fetch = fetch;
        return this;
    }

    public ObjectProxy setDepose(IocEventTrigger<Object> depose) {
        this.depose = depose;
        return this;
    }

    public <T> T get(Class<T> classOfT, IocMaking ing) {
        Object re;
        if (this.obj != null) {
            re = this.obj;
        } else if (this.weaver != null) {
            re = this.weaver.onCreate(this.weaver.fill(ing, this.weaver.born(ing)));
        } else {
            throw Lang.makeThrow("NullProxy for '%s'!", ing.getObjectName());
        }
        if (this.fetch != null) {
            this.fetch.trigger(re);
        }
        return (T)re;
    }

    public void depose() {
        if (this.obj != null && this.depose != null) {
            this.depose.trigger(this.obj);
        }
    }
}

