/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc.aop.impl;

import java.util.List;
import org.nutz.aop.ClassDefiner;
import org.nutz.aop.DefaultClassDefiner;
import org.nutz.aop.MethodInterceptor;
import org.nutz.aop.asm.AsmClassAgent;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.aop.MirrorFactory;
import org.nutz.ioc.aop.config.AopConfigration;
import org.nutz.ioc.aop.config.InterceptorPair;
import org.nutz.ioc.aop.config.impl.AnnotationAopConfigration;
import org.nutz.lang.Mirror;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class DefaultMirrorFactory
implements MirrorFactory {
    private static final Log log = Logs.get();
    private Ioc ioc;
    private ClassDefiner cd;
    private AopConfigration aopConfigration;
    private static final Object lock = new Object();

    public DefaultMirrorFactory(Ioc ioc) {
        this.ioc = ioc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Mirror<T> getMirror(Class<T> type, String name) {
        List<InterceptorPair> interceptorPairs;
        if (MethodInterceptor.class.isAssignableFrom(type) || type.getName().endsWith("$$NUTZAOP") || "$aop".equals(name) || AopConfigration.class.isAssignableFrom(type)) {
            return Mirror.me(type);
        }
        if (this.aopConfigration == null) {
            this.aopConfigration = this.ioc.has("$aop") ? this.ioc.get(AopConfigration.class, "$aop") : new AnnotationAopConfigration();
        }
        if ((interceptorPairs = this.aopConfigration.getInterceptorPairList(this.ioc, type)) == null || interceptorPairs.size() < 1) {
            if (log.isDebugEnabled()) {
                log.debugf("%s , no config to enable AOP.", type);
            }
            return Mirror.me(type);
        }
        Object object = lock;
        synchronized (object) {
            if (this.cd == null) {
                ClassLoader cd = type.getClassLoader();
                if (cd == null && (cd = Thread.currentThread().getContextClassLoader()) == null) {
                    cd = this.getClass().getClassLoader();
                }
                log.info("Use as AOP ClassLoader parent : " + cd);
                this.cd = new DefaultClassDefiner(cd);
            }
            AsmClassAgent agent = new AsmClassAgent();
            for (InterceptorPair interceptorPair : interceptorPairs) {
                agent.addInterceptor(interceptorPair.getMethodMatcher(), interceptorPair.getMethodInterceptor());
            }
            return Mirror.me(agent.define(this.cd, type));
        }
    }

    public void setAopConfigration(AopConfigration aopConfigration) {
        this.aopConfigration = aopConfigration;
    }
}

