/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.nutz.ioc.Ioc2;
import org.nutz.ioc.IocContext;
import org.nutz.ioc.IocException;
import org.nutz.ioc.IocLoader;
import org.nutz.ioc.IocLoading;
import org.nutz.ioc.IocMaking;
import org.nutz.ioc.ObjectMaker;
import org.nutz.ioc.ObjectProxy;
import org.nutz.ioc.ValueProxyMaker;
import org.nutz.ioc.annotation.InjectName;
import org.nutz.ioc.aop.MirrorFactory;
import org.nutz.ioc.aop.impl.DefaultMirrorFactory;
import org.nutz.ioc.impl.ComboContext;
import org.nutz.ioc.impl.DefaultValueProxyMaker;
import org.nutz.ioc.impl.ObjectMakerImpl;
import org.nutz.ioc.impl.ScopeContext;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.ioc.loader.cached.CachedIocLoader;
import org.nutz.ioc.loader.cached.CachedIocLoaderImpl;
import org.nutz.ioc.meta.IocObject;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.repo.LevenshteinDistance;

public class NutIoc
implements Ioc2 {
    private static final Object lock_get = new Object();
    private static final Log log = Logs.get();
    private static final String DEF_SCOPE = "app";
    private IocLoader loader;
    private IocContext context;
    private ObjectMaker maker;
    private List<ValueProxyMaker> vpms;
    private MirrorFactory mirrors;
    private String defaultScope;
    private Set<String> supportedTypes;
    private boolean deposed = false;

    public NutIoc(IocLoader loader) {
        this(loader, new ScopeContext(DEF_SCOPE), DEF_SCOPE);
    }

    public NutIoc(IocLoader loader, IocContext context, String defaultScope) {
        this(new ObjectMakerImpl(), loader, context, defaultScope);
    }

    protected NutIoc(ObjectMaker maker, IocLoader loader, IocContext context, String defaultScope) {
        this(maker, loader, context, defaultScope, null);
    }

    protected NutIoc(ObjectMaker maker, IocLoader loader, IocContext context, String defaultScope, MirrorFactory mirrors) {
        this.maker = maker;
        this.defaultScope = defaultScope;
        this.context = context;
        this.loader = loader instanceof CachedIocLoader ? loader : CachedIocLoaderImpl.create(loader);
        this.vpms = new ArrayList<ValueProxyMaker>(5);
        this.addValueProxyMaker(new DefaultValueProxyMaker());
        this.mirrors = mirrors == null ? new DefaultMirrorFactory(this) : mirrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IocLoading createLoading() {
        if (this.supportedTypes == null) {
            NutIoc nutIoc = this;
            synchronized (nutIoc) {
                if (this.supportedTypes == null) {
                    this.supportedTypes = new HashSet<String>();
                    for (ValueProxyMaker maker : this.vpms) {
                        String[] ss = maker.supportedTypes();
                        if (ss == null) continue;
                        String[] stringArray = ss;
                        int n = ss.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String s = stringArray[n2];
                            this.supportedTypes.add(s);
                            ++n2;
                        }
                    }
                }
            }
        }
        return new IocLoading(this.supportedTypes);
    }

    @Override
    public <T> T get(Class<T> type) throws IocException {
        InjectName inm = type.getAnnotation(InjectName.class);
        if (inm != null && !Strings.isBlank(inm.value())) {
            return this.get(type, inm.value());
        }
        IocBean iocBean = type.getAnnotation(IocBean.class);
        if (iocBean != null && !Strings.isBlank(iocBean.name())) {
            return this.get(type, iocBean.name());
        }
        return this.get(type, Strings.lowerFirst(type.getSimpleName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T get(Class<T> type, String name, IocContext context) throws IocException {
        Object object;
        IocMaking ing;
        IocContext cntx;
        ObjectProxy op;
        if (log.isDebugEnabled()) {
            log.debugf("Get '%s'<%s>", name, type);
        }
        if ((op = (cntx = (ing = this.makeIocMaking(context, name)).getContext()).fetch(name)) == null) {
            object = lock_get;
            synchronized (object) {
                op = cntx.fetch(name);
                if (op == null) {
                    try {
                        IocObject iobj;
                        if (log.isDebugEnabled()) {
                            log.debug("\t >> Load definition");
                        }
                        if ((iobj = this.loader.load(this.createLoading(), name)) == null) {
                            String[] stringArray = this.loader.getName();
                            int n = stringArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String iocBeanName = stringArray[n2];
                                if (3 > LevenshteinDistance.computeLevenshteinDistance(name.toLowerCase(), iocBeanName.toLowerCase())) {
                                    throw new IocException("Undefined object '%s' but found similar name '%s'", name, iocBeanName);
                                }
                                ++n2;
                            }
                            throw new IocException("Undefined object '%s'", name);
                        }
                        if (iobj.getType() == null) {
                            if (type == null) {
                                throw new IocException("NULL TYPE object '%s'", name);
                            }
                            iobj.setType(type);
                        }
                        if (Strings.isBlank(iobj.getScope())) {
                            iobj.setScope(this.defaultScope);
                        }
                        if (log.isDebugEnabled()) {
                            log.debugf("\t >> Make...'%s'<%s>", name, type);
                        }
                        op = this.maker.make(ing, iobj);
                    }
                    catch (IocException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new IocException(Lang.unwrapThrow(e), "For object [%s] - type:[%s]", name, type);
                    }
                }
            }
        }
        object = lock_get;
        synchronized (object) {
            return op.get(type, ing);
        }
    }

    @Override
    public <T> T get(Class<T> type, String name) {
        return this.get(type, name, null);
    }

    @Override
    public boolean has(String name) {
        return this.loader.has(name);
    }

    @Override
    public void depose() {
        if (this.deposed) {
            if (log.isInfoEnabled()) {
                log.info("You can't depose a Ioc twice!");
            }
            return;
        }
        this.context.depose();
        this.deposed = true;
        if (this.loader instanceof CachedIocLoader) {
            ((CachedIocLoader)this.loader).clear();
        }
        if (log.isDebugEnabled()) {
            log.debug("!!!Ioc is deposed, you can't use it anymore");
        }
    }

    @Override
    public void reset() {
        this.context.clear();
        if (this.loader instanceof CachedIocLoader) {
            ((CachedIocLoader)this.loader).clear();
        }
    }

    @Override
    public String[] getNames() {
        return this.loader.getName();
    }

    @Override
    public void addValueProxyMaker(ValueProxyMaker vpm) {
        this.vpms.add(0, vpm);
    }

    @Override
    public IocContext getIocContext() {
        return this.context;
    }

    public void setMaker(ObjectMaker maker) {
        this.maker = maker;
    }

    public void setMirrorFactory(MirrorFactory mirrors) {
        this.mirrors = mirrors;
    }

    public void setDefaultScope(String defaultScope) {
        this.defaultScope = defaultScope;
    }

    public IocMaking makeIocMaking(IocContext context, String name) {
        IocContext cntx;
        if (context == null || context == this.context) {
            cntx = this.context;
        } else {
            if (log.isTraceEnabled()) {
                log.trace("Link contexts");
            }
            cntx = new ComboContext(context, this.context);
        }
        return new IocMaking(this, this.mirrors, cntx, this.maker, this.vpms, name);
    }

    public String toString() {
        return "/*NutIoc*/\n{\nloader:" + this.loader + ",\n}";
    }

    protected void finalize() throws Throwable {
        if (!this.deposed) {
            if (log.isInfoEnabled()) {
                log.info("Ioc depose tigger by finalize(), not a good idea!");
            }
            this.depose();
        }
    }
}

