/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc.impl;

import org.nutz.ioc.IocEventTrigger;
import org.nutz.ioc.IocException;
import org.nutz.ioc.IocMaking;
import org.nutz.ioc.ObjectMaker;
import org.nutz.ioc.ObjectProxy;
import org.nutz.ioc.ValueProxy;
import org.nutz.ioc.meta.IocEventSet;
import org.nutz.ioc.meta.IocField;
import org.nutz.ioc.meta.IocObject;
import org.nutz.ioc.trigger.MethodEventTrigger;
import org.nutz.ioc.weaver.DefaultWeaver;
import org.nutz.ioc.weaver.FieldInjector;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;

public class ObjectMakerImpl
implements ObjectMaker {
    @Override
    public ObjectProxy make(IocMaking ing, IocObject iobj) {
        Mirror<?> mirror = ing.getMirrors().getMirror(iobj.getType(), ing.getObjectName());
        IocEventSet iocEventSet = iobj.getEvents();
        ObjectProxy op = new ObjectProxy();
        if (iobj.isSingleton() && ing.getObjectName() != null) {
            ing.getContext().save(iobj.getScope(), ing.getObjectName(), op);
        }
        if (iobj.getEvents() != null) {
            op.setFetch(ObjectMakerImpl.createTrigger(mirror, iocEventSet.getFetch()));
            op.setDepose(ObjectMakerImpl.createTrigger(mirror, iocEventSet.getDepose()));
        }
        try {
            DefaultWeaver dw = new DefaultWeaver();
            op.setWeaver(dw);
            if (iobj.getEvents() != null) {
                dw.setCreate(ObjectMakerImpl.createTrigger(mirror, iocEventSet.getCreate()));
            }
            ValueProxy[] vps = new ValueProxy[Lang.length(iobj.getArgs())];
            int i = 0;
            while (i < vps.length) {
                vps[i] = ing.makeValue(iobj.getArgs()[i]);
                ++i;
            }
            dw.setArgs(vps);
            Object[] args = new Object[vps.length];
            int i2 = 0;
            while (i2 < args.length) {
                args[i2] = vps[i2].get(ing);
                ++i2;
            }
            dw.setBorning(mirror.getBorning(args));
            Object obj = null;
            if (iobj.isSingleton()) {
                obj = dw.born(ing);
                op.setObj(obj);
            }
            FieldInjector[] fields = new FieldInjector[iobj.getFields().length];
            int i3 = 0;
            while (i3 < fields.length) {
                IocField ifld = iobj.getFields()[i3];
                try {
                    ValueProxy vp = ing.makeValue(ifld.getValue());
                    fields[i3] = FieldInjector.create(mirror, ifld.getName(), vp);
                }
                catch (Exception e) {
                    throw Lang.wrapThrow(e, "Fail to eval Injector for field: '%s'", ifld.getName());
                }
                ++i3;
            }
            dw.setFields(fields);
            if (obj != null) {
                dw.fill(ing, obj);
            }
            dw.onCreate(obj);
        }
        catch (Throwable e) {
            ing.getContext().remove(iobj.getScope(), ing.getObjectName());
            throw Lang.wrapThrow(e, IocException.class);
        }
        return op;
    }

    private static IocEventTrigger<Object> createTrigger(Mirror<?> mirror, String str) {
        if (Strings.isBlank(str)) {
            return null;
        }
        if (str.contains(".")) {
            try {
                return (IocEventTrigger)((Object)Mirror.me(Lang.loadClass(str)).born(new Object[0]));
            }
            catch (Exception e) {
                throw Lang.wrapThrow(e);
            }
        }
        try {
            return new MethodEventTrigger(mirror.findMethod(str, new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw Lang.wrapThrow(e);
        }
    }
}

