/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.util.MultiLineProperties;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.resource.NutResource;
import org.nutz.resource.Scans;

public class PropertiesProxy {
    private static final Log log = Logs.get();
    private final boolean utf8;
    private boolean ignoreResourceNotFound = false;
    private MultiLineProperties mp = new MultiLineProperties();

    public PropertiesProxy() {
        this(true);
    }

    public PropertiesProxy(boolean utf8) {
        this.utf8 = utf8;
    }

    public PropertiesProxy(String ... paths) {
        this(true);
        this.setPaths(paths);
    }

    public PropertiesProxy(InputStream in) {
        this(true);
        try {
            this.mp = new MultiLineProperties();
            this.mp.load(new InputStreamReader(in));
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public PropertiesProxy(Reader r) {
        this(true);
        try {
            this.mp = new MultiLineProperties();
            this.mp.load(r);
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public void setPaths(String ... paths) {
        this.mp = new MultiLineProperties();
        try {
            List<NutResource> list = this.getResources(paths);
            if (this.utf8) {
                for (NutResource nr : list) {
                    this.mp.load(nr.getReader(), false);
                }
            } else {
                Properties p = new Properties();
                for (NutResource nr : list) {
                    p.load(nr.getInputStream());
                }
                this.mp.putAll((Map)p);
            }
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
    }

    private List<NutResource> getResources(String ... paths) {
        ArrayList<NutResource> list = new ArrayList<NutResource>();
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            try {
                List<NutResource> resources = Scans.me().loadResource("^.+[.]properties$", path);
                list.addAll(resources);
            }
            catch (Exception e) {
                if (this.ignoreResourceNotFound) {
                    if (log.isWarnEnabled()) {
                        log.warn("Could not load resource from " + path + ": " + e.getMessage());
                    }
                }
                throw Lang.wrapThrow(e);
            }
            ++n2;
        }
        return list;
    }

    public void setIgnoreResourceNotFound(boolean ignoreResourceNotFound) {
        this.ignoreResourceNotFound = ignoreResourceNotFound;
    }

    public boolean has(String key) {
        return this.mp.containsKey(key);
    }

    public void put(String key, String value) {
        this.mp.put(key, value);
    }

    public String get(String key) {
        return this.mp.get(key);
    }

    public String get(String key, String defaultValue) {
        return Strings.sNull(this.mp.get(key), defaultValue);
    }

    public String trim(String key) {
        return Strings.trim(this.get(key));
    }

    public String trim(String key, String defaultValue) {
        return Strings.trim(this.get(key, defaultValue));
    }

    public int getInt(String key) {
        return this.getInt(key, -1);
    }

    public int getInt(String key, int defaultValue) {
        try {
            return Integer.parseInt(this.get(key));
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public long getLong(String key) {
        return this.getLong(key, -1L);
    }

    public long getLong(String key, long dfval) {
        try {
            return Long.parseLong(this.get(key));
        }
        catch (NumberFormatException numberFormatException) {
            return dfval;
        }
    }

    public String getTrim(String key) {
        return Strings.trim(this.get(key));
    }

    public String getTrim(String key, String defaultValue) {
        return Strings.trim(this.get(key, defaultValue));
    }

    public List<String> getKeys() {
        return this.mp.keys();
    }

    public Collection<String> getValues() {
        return this.mp.values();
    }

    public Properties toProperties() {
        Properties p = new Properties();
        for (String key : this.mp.keySet()) {
            p.put(key, this.mp.get(key));
        }
        return p;
    }

    public Map<String, String> toMap() {
        return new HashMap<String, String>(this.mp);
    }
}

