/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc.java;

import org.nutz.ioc.java.BooleanNode;
import org.nutz.ioc.java.ChainNode;
import org.nutz.ioc.java.FieldNode;
import org.nutz.ioc.java.IocContextNode;
import org.nutz.ioc.java.IocObjectNameNode;
import org.nutz.ioc.java.IocObjectNode;
import org.nutz.ioc.java.IocSelfNode;
import org.nutz.ioc.java.NullNode;
import org.nutz.ioc.java.NumberNode;
import org.nutz.ioc.java.ObjectFunctionNode;
import org.nutz.ioc.java.StaticFunctionNode;
import org.nutz.ioc.java.StringNode;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.util.LinkedArray;
import org.nutz.lang.util.LinkedCharArray;

public class ChainParsing {
    private char[] cs;
    private int i;
    private ChainNode first;
    private ChainNode last;
    private LinkedArray<LinkedArray<ChainNode>> argss;
    private LinkedCharArray ends = new LinkedCharArray(10);
    private StringBuilder sb = new StringBuilder();

    public ChainParsing(String s) {
        this.argss = new LinkedArray(5);
        this.cs = s.toCharArray();
        this.parse();
    }

    private void parse() {
        while (this.i < this.cs.length) {
            char c = this.cs[this.i];
            if (c == ',') {
                this.checkIfNeedAddNode();
            } else if (c == '\'' || c == '\"') {
                this.clearStringBuffer();
                ++this.i;
                while (this.i < this.cs.length) {
                    char n = this.cs[this.i];
                    if (n == c) break;
                    this.sb.append(n);
                    ++this.i;
                }
                this.addNode(new StringNode(this.clearStringBuffer()));
            } else if (c == '@') {
                String name = this.readToDot().toUpperCase();
                if ("IOC".equals(name)) {
                    this.addNode(new IocSelfNode());
                } else if ("CONTEXT".equals(name)) {
                    this.addNode(new IocContextNode());
                } else if ("NAME".equals(name)) {
                    this.addNode(new IocObjectNameNode());
                }
            } else if (c == '$') {
                String name = this.readToDot();
                this.addNode(new IocObjectNode(name));
            } else if (c == '(') {
                String funcName = Strings.trim(this.clearStringBuffer());
                this.argss.push(new LinkedArray<ChainNode>(ChainNode.class, 5));
                this.ends.push(')');
                ++this.i;
                this.parse();
                this.ends.popLast();
                ChainNode[] args = this.argss.popLast().toArray();
                int pos = funcName.lastIndexOf(46);
                if (pos > 0) {
                    String className = funcName.substring(0, pos);
                    funcName = funcName.substring(pos + 1);
                    this.addNode(new StaticFunctionNode(className, funcName, args));
                } else {
                    this.addNode(new ObjectFunctionNode(funcName, args));
                }
                this.clearStringBuffer();
            } else {
                if (this.ends.size() > 0 && c == this.ends.last()) {
                    this.checkIfNeedAddNode();
                    return;
                }
                this.sb.append(c);
            }
            ++this.i;
        }
        this.checkIfNeedAddNode();
    }

    private void checkIfNeedAddNode() {
        if (!Strings.isBlank(this.sb)) {
            String s = Strings.trim(this.clearStringBuffer());
            if (s.equalsIgnoreCase("null")) {
                this.addNode(new NullNode());
            } else if (s.matches("^(true|false)$")) {
                this.addNode(new BooleanNode(s));
            } else if (s.matches("^([0-9]+)$")) {
                this.addNode(new NumberNode(s));
            } else if (this.last == null) {
                int pos = s.lastIndexOf(46);
                if (pos < 0) {
                    throw Lang.makeThrow("Don't know how to invoke '%s'", s);
                }
                String className = s.substring(0, pos);
                String funcName = s.substring(pos + 1);
                this.addNode(new StaticFunctionNode(className, funcName, new ChainNode[0]));
            } else {
                this.addNode(new FieldNode(s));
            }
        }
    }

    private String readToDot() {
        ++this.i;
        while (this.i < this.cs.length) {
            char c = this.cs[this.i];
            if (c == '.' || c == ',') break;
            this.sb.append(c);
            ++this.i;
        }
        return this.clearStringBuffer();
    }

    private String clearStringBuffer() {
        String re = Strings.trim(this.sb);
        this.sb = new StringBuilder();
        return re;
    }

    private void addNode(ChainNode node) {
        if (this.argss.size() > 0) {
            this.argss.last().push(node);
        } else if (this.last == null) {
            this.first = node;
            this.last = node;
        } else {
            this.last.setNext(node);
            this.last = node;
        }
    }

    public ChainNode getNode() {
        return this.first;
    }
}

