/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc.loader.combo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.nutz.ioc.IocLoader;
import org.nutz.ioc.IocLoading;
import org.nutz.ioc.ObjectLoadException;
import org.nutz.ioc.loader.annotation.AnnotationIocLoader;
import org.nutz.ioc.loader.json.JsonLoader;
import org.nutz.ioc.loader.xml.XmlIocLoader;
import org.nutz.ioc.meta.IocObject;
import org.nutz.json.Json;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class ComboIocLoader
implements IocLoader {
    private static final Log log = Logs.get();
    private List<IocLoader> iocLoaders = new ArrayList<IocLoader>();
    private static Map<String, Class<? extends IocLoader>> loaders = new HashMap<String, Class<? extends IocLoader>>();

    static {
        loaders.put("js", JsonLoader.class);
        loaders.put("json", JsonLoader.class);
        loaders.put("xml", XmlIocLoader.class);
        loaders.put("annotation", AnnotationIocLoader.class);
    }

    public ComboIocLoader(String ... args) throws ClassNotFoundException {
        ArrayList<String> argsList = null;
        String currentClassName = null;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.length() > 0 && str.charAt(0) == '*') {
                if (argsList != null) {
                    this.createIocLoader(currentClassName, (List<String>)argsList);
                }
                currentClassName = str.substring(1);
                argsList = new ArrayList<String>();
            } else {
                if (argsList == null) {
                    throw new IllegalArgumentException("ioc args without Loader ClassName. " + args);
                }
                argsList.add(str);
            }
            ++n2;
        }
        if (currentClassName != null) {
            this.createIocLoader(currentClassName, argsList);
        }
        HashSet<String> beanNames = new HashSet<String>();
        for (IocLoader loader : this.iocLoaders) {
            String[] stringArray2 = loader.getName();
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String beanName = stringArray2[n4];
                if (!beanNames.add(beanName) && log.isWarnEnabled()) {
                    log.warnf("Found Duplicate beanName=%s, pls check you config!", beanName);
                }
                ++n4;
            }
        }
    }

    private void createIocLoader(String className, List<String> args) throws ClassNotFoundException {
        Class<IocLoader> klass = loaders.get(className);
        if (klass == null) {
            klass = Lang.loadClass(className);
        }
        this.iocLoaders.add((IocLoader)((Object)Mirror.me(klass).born(args.toArray(new Object[args.size()]))));
    }

    public ComboIocLoader(IocLoader ... loaders) {
        IocLoader[] iocLoaderArray = loaders;
        int n = loaders.length;
        int n2 = 0;
        while (n2 < n) {
            IocLoader iocLoader = iocLoaderArray[n2];
            if (iocLoader != null) {
                this.iocLoaders.add(iocLoader);
            }
            ++n2;
        }
    }

    @Override
    public String[] getName() {
        ArrayList<String> list = new ArrayList<String>();
        for (IocLoader iocLoader : this.iocLoaders) {
            String[] stringArray = iocLoader.getName();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                list.add(name);
                ++n2;
            }
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public boolean has(String name) {
        for (IocLoader iocLoader : this.iocLoaders) {
            if (!iocLoader.has(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IocObject load(IocLoading loading, String name) throws ObjectLoadException {
        for (IocLoader iocLoader : this.iocLoaders) {
            if (!iocLoader.has(name)) continue;
            IocObject iocObject = iocLoader.load(loading, name);
            if (log.isDebugEnabled()) {
                log.debugf("Found IocObject(%s) in IocLoader(%s)", name, String.valueOf(iocLoader.getClass().getSimpleName()) + "@" + iocLoader.hashCode());
            }
            return iocObject;
        }
        throw new ObjectLoadException("Object '" + name + "' without define!");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("/*ComboIocLoader*/\n{");
        for (IocLoader loader : this.iocLoaders) {
            String str = Json.toJson(loader);
            str = str.replaceFirst("[{]", "");
            int index = str.lastIndexOf("}");
            StringBuilder sb2 = new StringBuilder(str);
            sb2.setCharAt(index, ' ');
            sb.append((CharSequence)sb2).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }
}

