/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc.loader.map;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.nutz.ioc.IocLoader;
import org.nutz.ioc.IocLoading;
import org.nutz.ioc.Iocs;
import org.nutz.ioc.ObjectLoadException;
import org.nutz.ioc.meta.IocObject;
import org.nutz.json.Json;
import org.nutz.lang.Lang;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class MapLoader
implements IocLoader {
    private static final Log log = Logs.get();
    private Map<String, Map<String, Object>> map;

    protected MapLoader() {
        this.map = new HashMap<String, Map<String, Object>>();
    }

    public MapLoader(String json) {
        this((Map)Json.fromJson(json));
    }

    public MapLoader(Map<String, Map<String, Object>> map) {
        this.map = map;
    }

    public Map<String, Map<String, Object>> getMap() {
        return this.map;
    }

    public void setMap(Map<String, Map<String, Object>> map) {
        this.map = map;
    }

    @Override
    public String[] getName() {
        return this.map.keySet().toArray(new String[this.map.size()]);
    }

    @Override
    public boolean has(String name) {
        return this.map.containsKey(name);
    }

    @Override
    public IocObject load(IocLoading loading, String name) throws ObjectLoadException {
        Object p;
        Map<String, Object> m = this.getMap(name);
        if (m == null) {
            throw new ObjectLoadException("Object '" + name + "' without define!");
        }
        if (log.isDebugEnabled()) {
            log.debug("Loading define for name=" + name);
        }
        if ((p = m.get("parent")) != null) {
            this.checkParents(name);
            IocObject parent = this.load(loading, p.toString());
            HashMap<String, Object> newMap = new HashMap<String, Object>();
            for (Map.Entry<String, Object> en : m.entrySet()) {
                if ("parent".equals(en.getKey())) continue;
                newMap.put(en.getKey(), en.getValue());
            }
            IocObject self = loading.map2iobj(newMap);
            return Iocs.mergeWith(self, parent);
        }
        return loading.map2iobj(m);
    }

    private void checkParents(String name) throws ObjectLoadException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(name);
        String currentParent = this.map.get(name).get("parent").toString();
        while (currentParent != null) {
            if (list.contains(currentParent)) {
                throw Lang.makeThrow(ObjectLoadException.class, "!!!Inheritance cycle! id = %s", name);
            }
            list.add(currentParent);
            Map<String, Object> obj = this.map.get(currentParent);
            if (obj != null && obj instanceof Map) {
                currentParent = (String)obj.get("parent");
                continue;
            }
            throw Lang.makeThrow(ObjectLoadException.class, "!!!Inheritance errors! id = %s", name);
        }
    }

    private Map<String, Object> getMap(String name) {
        return this.map.get(name);
    }

    public String toString() {
        return "/*" + this.getClass().getSimpleName() + "*/\n" + Json.toJson(this.map);
    }
}

