/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.json;

import java.util.regex.Pattern;
import org.nutz.castor.Castors;

public class JsonFormat {
    private int indent;
    private String indentBy;
    private boolean compact;
    private boolean quoteName;
    private boolean ignoreNull;
    private Pattern actived;
    private Pattern locked;
    private Castors castors;
    private char separator;
    private boolean autoUnicode;

    public static JsonFormat compact() {
        return new JsonFormat(true).setIgnoreNull(true);
    }

    public static JsonFormat full() {
        return new JsonFormat(false).setIgnoreNull(false);
    }

    public static JsonFormat nice() {
        return new JsonFormat(false).setIgnoreNull(true);
    }

    public static JsonFormat forLook() {
        return new JsonFormat(false).setQuoteName(false).setIgnoreNull(true);
    }

    public JsonFormat() {
        this(true);
    }

    public JsonFormat(boolean compact) {
        this.compact = compact;
        this.indentBy = "   ";
        this.quoteName = true;
        this.castors = Castors.me();
        this.separator = (char)34;
    }

    public boolean ignore(String name) {
        if (this.actived != null) {
            return !this.actived.matcher(name).find();
        }
        if (this.locked != null) {
            return this.locked.matcher(name).find();
        }
        return false;
    }

    public boolean isCompact() {
        return this.compact;
    }

    public JsonFormat setCompact(boolean compact) {
        this.compact = compact;
        return this;
    }

    public int getIndent() {
        return this.indent;
    }

    public JsonFormat setIndent(int indent) {
        this.indent = indent;
        return this;
    }

    public JsonFormat increaseIndent() {
        ++this.indent;
        return this;
    }

    public JsonFormat decreaseIndent() {
        --this.indent;
        return this;
    }

    public String getIndentBy() {
        return this.indentBy;
    }

    public JsonFormat setIndentBy(String indentBy) {
        this.indentBy = indentBy;
        return this;
    }

    public boolean isQuoteName() {
        return this.quoteName;
    }

    public JsonFormat setQuoteName(boolean qn) {
        this.quoteName = qn;
        return this;
    }

    public boolean isIgnoreNull() {
        return this.ignoreNull;
    }

    public JsonFormat setIgnoreNull(boolean ignoreNull) {
        this.ignoreNull = ignoreNull;
        return this;
    }

    public JsonFormat setActived(String regex) {
        this.actived = Pattern.compile(regex);
        return this;
    }

    public JsonFormat setLocked(String regex) {
        this.locked = Pattern.compile(regex);
        return this;
    }

    public Castors getCastors() {
        return this.castors == null ? Castors.me() : this.castors;
    }

    public JsonFormat setCastors(Castors castors) {
        this.castors = castors;
        return this;
    }

    public JsonFormat setSeparator(char separator) {
        this.separator = separator;
        return this;
    }

    public char getSeparator() {
        return this.separator;
    }

    public JsonFormat setAutoUnicode(boolean autoUnicode) {
        this.autoUnicode = autoUnicode;
        return this;
    }

    public boolean isAutoUnicode() {
        return this.autoUnicode;
    }
}

