/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.json.entity;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nutz.json.JsonException;
import org.nutz.json.JsonField;
import org.nutz.json.JsonFormat;
import org.nutz.json.ToJson;
import org.nutz.json.entity.JsonEntityField;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.lang.born.Borning;
import org.nutz.lang.born.BorningException;
import org.nutz.lang.util.Callback;
import org.nutz.lang.util.Callback3;

public class JsonEntity {
    private List<JsonEntityField> fields;
    private Map<String, JsonEntityField> fieldMap = new HashMap<String, JsonEntityField>();
    private Borning<?> borning;
    private BorningException err;
    private Map<String, Integer> typeParams;
    private Method toJsonMethod;

    public JsonEntity(Mirror<?> mirror) {
        int n;
        Type type = mirror.getActuallyType();
        this.typeParams = new HashMap<String, Integer>();
        if (type instanceof ParameterizedType) {
            ParameterizedType pmType = (ParameterizedType)type;
            int i = 0;
            Type[] typeArray = pmType.getActualTypeArguments();
            int n2 = typeArray.length;
            n = 0;
            while (n < n2) {
                Type pmA = typeArray[n];
                this.typeParams.put(pmA.toString(), i++);
                ++n;
            }
        }
        Field[] flds = mirror.getFields();
        this.fields = new ArrayList<JsonEntityField>(flds.length);
        AccessibleObject[] accessibleObjectArray = flds;
        n = flds.length;
        int pmA = 0;
        while (pmA < n) {
            Field fld = accessibleObjectArray[pmA];
            JsonEntityField ef = JsonEntityField.eval(mirror, fld);
            if (ef != null) {
                this.fields.add(ef);
                this.fieldMap.put(ef.getName(), ef);
            }
            ++pmA;
        }
        accessibleObjectArray = mirror.getMethods();
        n = accessibleObjectArray.length;
        pmA = 0;
        while (pmA < n) {
            AccessibleObject m = accessibleObjectArray[pmA];
            JsonField jf = ((Method)m).getAnnotation(JsonField.class);
            if (jf != null && !jf.ignore()) {
                AccessibleObject method = m;
                Callback<Method> whenError = new Callback<Method>(){

                    @Override
                    public void invoke(Method m) {
                        throw Lang.makeThrow(JsonException.class, "JsonField '%s' should be getter/setter pair!", m);
                    }
                };
                Callback3<String, Method, Method> whenOk = new Callback3<String, Method, Method>((Method)method, jf){
                    private final /* synthetic */ Method val$method;
                    private final /* synthetic */ JsonField val$jf;
                    {
                        this.val$method = method;
                        this.val$jf = jsonField;
                    }

                    @Override
                    public void invoke(String name, Method getter, Method setter) {
                        if (getter == null || setter == null || Strings.isBlank(name)) {
                            throw Lang.makeThrow(JsonException.class, "JsonField '%s' should be getter/setter pair!", this.val$method);
                        }
                        JsonEntityField ef = JsonEntityField.eval(Strings.sBlank(this.val$jf.value(), name), getter, setter);
                        JsonEntity.this.fields.add(ef);
                        JsonEntity.this.fieldMap.put(ef.getName(), ef);
                    }
                };
                Mirror.evalGetterSetter((Method)m, whenOk, whenError);
            }
            ++pmA;
        }
        try {
            this.borning = mirror.getBorning(new Object[0]);
        }
        catch (BorningException e) {
            this.err = e;
        }
        Class<?> klass = mirror.getType();
        ToJson tj = klass.getAnnotation(ToJson.class);
        String myMethodName = Strings.sNull(tj == null ? null : tj.value(), "toJson");
        try {
            Method myMethod;
            try {
                myMethod = klass.getMethod(myMethodName, new Class[0]);
                if (!myMethod.isAccessible()) {
                    myMethod.setAccessible(true);
                }
                this.toJsonMethod = myMethod;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    myMethod = klass.getMethod(myMethodName, JsonFormat.class);
                    if (!myMethod.isAccessible()) {
                        myMethod.setAccessible(true);
                    }
                    this.toJsonMethod = myMethod;
                }
                catch (NoSuchMethodException noSuchMethodException2) {}
            }
        }
        catch (Exception e) {
            throw Lang.wrapThrow(e);
        }
    }

    public List<JsonEntityField> getFields() {
        return this.fields;
    }

    public Object born() {
        if (this.borning == null) {
            throw this.err;
        }
        return this.borning.born(new Object[0]);
    }

    public JsonEntityField getField(String name) {
        return this.fieldMap.get(name);
    }

    public Method getToJsonMethod() {
        return this.toJsonMethod;
    }
}

