/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.json.impl;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.json.JsonRender;
import org.nutz.json.entity.JsonEntity;
import org.nutz.json.entity.JsonEntityField;
import org.nutz.lang.FailToGetValueException;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;

public class JsonRenderImpl
implements JsonRender {
    private static String NL = "\n";
    private JsonFormat format;
    private Writer writer;
    private Set<Object> memo = new HashSet<Object>();
    private static final Pattern p = Pattern.compile("^[a-z_A-Z$]+[a-zA-Z_0-9$]*$");

    @Override
    public void render(Object obj) throws IOException {
        if (obj == null) {
            this.writer.write("null");
        } else if (obj instanceof JsonRender) {
            ((JsonRender)obj).render(null);
        } else if (obj instanceof Class) {
            this.string2Json(((Class)obj).getName());
        } else if (obj instanceof Mirror) {
            this.string2Json(((Mirror)obj).getType().getName());
        } else {
            Mirror<Class<?>> mr = Mirror.me(obj.getClass());
            if (mr.isEnum()) {
                this.string2Json(((Enum)obj).name());
            } else if (mr.isNumber() || mr.isBoolean()) {
                this.writer.append(obj.toString());
            } else if (mr.isStringLike() || mr.isChar()) {
                this.string2Json(obj.toString());
            } else if (mr.isDateTimeLike()) {
                this.string2Json(this.format.getCastors().castToString(obj));
            } else if (obj instanceof Map) {
                this.map2Json((Map)obj);
            } else if (obj instanceof Collection) {
                this.coll2Json((Collection)obj);
            } else if (obj.getClass().isArray()) {
                this.array2Json(obj);
            } else {
                this.memo.add(obj);
                this.pojo2Json(obj);
                this.memo.remove(obj);
            }
        }
    }

    public JsonRenderImpl(Writer writer, JsonFormat format) {
        this.format = format;
        this.writer = writer;
    }

    private static boolean isCompact(JsonRenderImpl render) {
        return render.format.isCompact();
    }

    private void appendName(String name) throws IOException {
        if (this.format.isQuoteName() || !p.matcher(name).find()) {
            this.string2Json(name);
        } else {
            this.writer.append(name);
        }
    }

    private void appendPairBegin() throws IOException {
        if (!JsonRenderImpl.isCompact(this)) {
            this.writer.append(NL).append(Strings.dup(this.format.getIndentBy(), this.format.getIndent()));
        }
    }

    private void appendPairSep() throws IOException {
        this.writer.append(!JsonRenderImpl.isCompact(this) ? " :" : ":");
    }

    protected void appendPair(boolean needPairEnd, String name, Object value) throws IOException {
        this.appendPairBegin();
        this.appendName(name);
        this.appendPairSep();
        this.render(value);
        if (needPairEnd) {
            this.appendPairEnd();
        }
    }

    private boolean isIgnore(String name, Object value) {
        if (value == null && this.format.isIgnoreNull()) {
            return true;
        }
        return this.format.ignore(name);
    }

    private void appendPairEnd() throws IOException {
        this.writer.append(',');
    }

    private void appendBraceBegin() throws IOException {
        this.writer.append('{');
    }

    private void appendBraceEnd() throws IOException {
        if (!JsonRenderImpl.isCompact(this)) {
            this.writer.append(NL).append(Strings.dup(this.format.getIndentBy(), this.format.getIndent()));
        }
        this.writer.append('}');
    }

    private void map2Json(Map map) throws IOException {
        if (map == null) {
            return;
        }
        this.appendBraceBegin();
        this.increaseFormatIndent();
        ArrayList<Pair> list = new ArrayList<Pair>(map.size());
        Set entrySet = map.entrySet();
        for (Map.Entry entry : entrySet) {
            Object value;
            String name = entry.getKey() == null ? "null" : entry.getKey().toString();
            if (this.isIgnore(name, value = entry.getValue())) continue;
            list.add(new Pair(name, value));
        }
        this.writeItem(list);
    }

    private void pojo2Json(Object obj) throws IOException {
        if (obj == null) {
            return;
        }
        Class<?> type = obj.getClass();
        JsonEntity jen = Json.getEntity(Mirror.me(type));
        Method toJsonMethod = jen.getToJsonMethod();
        if (toJsonMethod != null) {
            try {
                if (toJsonMethod.getParameterTypes().length == 0) {
                    this.writer.append(String.valueOf(toJsonMethod.invoke(obj, new Object[0])));
                } else {
                    this.writer.append(String.valueOf(toJsonMethod.invoke(obj, this.format)));
                }
                return;
            }
            catch (Exception e) {
                throw Lang.wrapThrow(e);
            }
        }
        List<JsonEntityField> fields = jen.getFields();
        this.appendBraceBegin();
        this.increaseFormatIndent();
        ArrayList<Pair> list = new ArrayList<Pair>(fields.size());
        for (JsonEntityField jef : fields) {
            if (jef.isIgnore()) continue;
            String name = jef.getName();
            try {
                Mirror<Object> mirror;
                Object value = jef.getValue(obj);
                if (this.isIgnore(name, value)) continue;
                if (value != null && (mirror = Mirror.me(value)).isPojo() && this.memo.contains(value)) {
                    value = null;
                }
                if (value != null && jef.isForceString()) {
                    if (value.getClass().isArray()) {
                        String[] ss = new String[Array.getLength(value)];
                        int i = 0;
                        while (i < ss.length) {
                            ss[i] = Array.get(value, i).toString();
                            ++i;
                        }
                        value = ss;
                    } else if (value instanceof Collection) {
                        Collection col = (Collection)Mirror.me(value).born(new Object[0]);
                        for (Object ele : (Collection)value) {
                            col.add(ele.toString());
                        }
                        value = col;
                    } else {
                        value = value.toString();
                    }
                }
                list.add(new Pair(name, value));
            }
            catch (FailToGetValueException failToGetValueException) {}
        }
        this.writeItem(list);
    }

    private void writeItem(List<Pair> list) throws IOException {
        Iterator<Pair> it = list.iterator();
        while (it.hasNext()) {
            Pair p = it.next();
            this.appendPair(it.hasNext(), p.name, p.value);
        }
        this.decreaseFormatIndent();
        this.appendBraceEnd();
    }

    private void decreaseFormatIndent() {
        if (!JsonRenderImpl.isCompact(this)) {
            this.format.decreaseIndent();
        }
    }

    private void increaseFormatIndent() {
        if (!JsonRenderImpl.isCompact(this)) {
            this.format.increaseIndent();
        }
    }

    private void string2Json(String s) throws IOException {
        if (s == null) {
            this.writer.append("null");
        } else {
            char[] cs = s.toCharArray();
            this.writer.append(this.format.getSeparator());
            char[] cArray = cs;
            int n = cs.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                switch (c) {
                    case '\"': {
                        this.writer.append("\\\"");
                        break;
                    }
                    case '\n': {
                        this.writer.append("\\n");
                        break;
                    }
                    case '\t': {
                        this.writer.append("\\t");
                        break;
                    }
                    case '\r': {
                        this.writer.append("\\r");
                        break;
                    }
                    case '\\': {
                        this.writer.append("\\\\");
                        break;
                    }
                    default: {
                        if (c >= '\u0100' && this.format.isAutoUnicode()) {
                            this.writer.append("\\u").append(Integer.toHexString(c).toUpperCase());
                            break;
                        }
                        this.writer.append(c);
                    }
                }
                ++n2;
            }
            this.writer.append(this.format.getSeparator());
        }
    }

    private void array2Json(Object obj) throws IOException {
        this.writer.append('[');
        int len = Array.getLength(obj) - 1;
        if (len > -1) {
            int i = 0;
            while (i < len) {
                this.render(Array.get(obj, i));
                this.appendPairEnd();
                this.writer.append(' ');
                ++i;
            }
            this.render(Array.get(obj, i));
        }
        this.writer.append(']');
    }

    private void coll2Json(Collection iterable) throws IOException {
        this.writer.append('[');
        Iterator it = iterable.iterator();
        while (it.hasNext()) {
            this.render(it.next());
            if (!it.hasNext()) break;
            this.appendPairEnd();
            this.writer.append(' ');
        }
        this.writer.append(']');
    }

    static class Pair {
        String name;
        Object value;

        public Pair(String name, Object value) {
            this.name = name;
            this.value = value;
        }
    }
}

