/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.nutz.lang.Encoding;
import org.nutz.lang.ExitLoop;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.lang.util.Callback;
import org.nutz.lang.util.ClassTools;
import org.nutz.lang.util.Disks;

public abstract class Files {
    public static String read(String path) {
        File f = Files.findFile(path);
        if (f == null) {
            throw Lang.makeThrow("Can not find file '%s'", path);
        }
        return Files.read(f);
    }

    public static String read(File f) {
        return Lang.readAll(Streams.fileInr(f));
    }

    public static byte[] readBytes(String path) {
        File f = Files.findFile(path);
        if (f == null) {
            throw Lang.makeThrow("Can not find file '%s'", path);
        }
        return Files.readBytes(f);
    }

    public static byte[] readBytes(File f) {
        return Streams.readBytesAndClose(Streams.buff(Streams.fileIn(f)));
    }

    public static void write(String path, Object obj) {
        if (path == null || obj == null) {
            return;
        }
        try {
            Files.write(Files.createFileIfNoExists(path), obj);
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public static void write(File f, Object obj) {
        if (f == null || obj == null) {
            return;
        }
        if (f.isDirectory()) {
            throw Lang.makeThrow("Directory '%s' can not be write as File", f);
        }
        try {
            if (!f.exists()) {
                Files.createNewFile(f);
            }
            if (obj instanceof InputStream) {
                Streams.writeAndClose(Streams.fileOut(f), (InputStream)obj);
            } else if (obj instanceof byte[]) {
                Streams.writeAndClose(Streams.fileOut(f), (byte[])obj);
            } else if (obj instanceof Reader) {
                Streams.writeAndClose(Streams.fileOutw(f), (Reader)obj);
            } else {
                Streams.writeAndClose(Streams.fileOutw(f), obj.toString());
            }
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public static void appendWrite(File f, Object obj) {
        if (f == null || obj == null) {
            return;
        }
        if (f.isDirectory()) {
            throw Lang.makeThrow("Directory '%s' can not be write as File", f);
        }
        try {
            if (!f.exists()) {
                Files.createNewFile(f);
            }
            if (obj instanceof InputStream) {
                throw Lang.noImplement();
            }
            if (obj instanceof byte[]) {
                throw Lang.noImplement();
            }
            if (obj instanceof Reader) {
                throw Lang.noImplement();
            }
            Streams.appendWriteAndClose(f, obj.toString());
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public static File renameSuffix(File f, String suffix) {
        if (f == null || suffix == null || suffix.length() == 0) {
            return f;
        }
        return new File(Files.renameSuffix(f.getAbsolutePath(), suffix));
    }

    public static String renameSuffix(String path, String suffix) {
        int pos = path.length();
        --pos;
        while (pos > 0) {
            if (path.charAt(pos) == '.') break;
            if (path.charAt(pos) == '/' || path.charAt(pos) == '\\') {
                pos = -1;
                break;
            }
            --pos;
        }
        if (pos <= 0) {
            return String.valueOf(path) + suffix;
        }
        return String.valueOf(path.substring(0, pos)) + suffix;
    }

    public static String getMajorName(String path) {
        int len = path.length();
        int l = 0;
        int r = len;
        int i = r - 1;
        while (i > 0) {
            if (r == len && path.charAt(i) == '.') {
                r = i;
            }
            if (path.charAt(i) == '/' || path.charAt(i) == '\\') {
                l = i + 1;
                break;
            }
            --i;
        }
        return path.substring(l, r);
    }

    public static String getMajorName(File f) {
        return Files.getMajorName(f.getAbsolutePath());
    }

    public static String getSuffixName(File f) {
        if (f == null) {
            return null;
        }
        return Files.getSuffixName(f.getAbsolutePath());
    }

    public static String getSuffixName(String path) {
        if (path == null) {
            return null;
        }
        int p0 = path.lastIndexOf(46);
        int p1 = path.lastIndexOf(47);
        if (-1 == p0 || p0 < p1) {
            return "";
        }
        return path.substring(p0 + 1);
    }

    public static ZipEntry[] findEntryInZip(ZipFile zip, String regex) {
        LinkedList<ZipEntry> list = new LinkedList<ZipEntry>();
        Enumeration<? extends ZipEntry> en = zip.entries();
        while (en.hasMoreElements()) {
            ZipEntry ze = en.nextElement();
            if (regex != null && !ze.getName().matches(regex)) continue;
            list.add(ze);
        }
        return list.toArray(new ZipEntry[list.size()]);
    }

    public static File createFileIfNoExists(String path) throws IOException {
        File f;
        String thePath = Disks.absolute(path);
        if (thePath == null) {
            thePath = Disks.normalize(path);
        }
        if (!(f = new File(thePath)).exists()) {
            Files.createNewFile(f);
        }
        if (!f.isFile()) {
            throw Lang.makeThrow("'%s' should be a file!", path);
        }
        return f;
    }

    public static File createFileIfNoExists(File f) {
        if (f == null) {
            return f;
        }
        if (!f.exists()) {
            try {
                Files.createNewFile(f);
            }
            catch (IOException e) {
                throw Lang.wrapThrow(e);
            }
        }
        if (!f.isFile()) {
            throw Lang.makeThrow("'%s' should be a file!", f);
        }
        return f;
    }

    public static File createDirIfNoExists(String path) {
        File f;
        String thePath = Disks.absolute(path);
        if (thePath == null) {
            thePath = Disks.normalize(path);
        }
        if (!(f = new File(thePath)).exists()) {
            Files.makeDir(f);
        }
        if (!f.isDirectory()) {
            throw Lang.makeThrow("'%s' should be a directory!", path);
        }
        return f;
    }

    public static File createDirIfNoExists(File d) {
        if (d == null) {
            return d;
        }
        if (!d.exists()) {
            Files.makeDir(d);
        }
        if (!d.isDirectory()) {
            throw Lang.makeThrow("'%s' should be a directory!", d);
        }
        return d;
    }

    public static File findFile(String path, ClassLoader klassLoader, String enc) {
        if ((path = Disks.absolute(path, klassLoader, enc)) == null) {
            return null;
        }
        return new File(path);
    }

    public static File findFile(String path, String enc) {
        return Files.findFile(path, ClassTools.getClassLoader(), enc);
    }

    public static File findFile(String path, ClassLoader klassLoader) {
        return Files.findFile(path, klassLoader, Encoding.defaultEncoding());
    }

    public static File findFile(String path) {
        return Files.findFile(path, ClassTools.getClassLoader(), Encoding.defaultEncoding());
    }

    public static File checkFile(String path) {
        File f = Files.findFile(path);
        if (f == null) {
            throw Lang.makeThrow("Fail to found file '%s'", path);
        }
        return f;
    }

    public static InputStream findFileAsStream(String path, Class<?> klass, String enc) {
        File f = new File(path);
        if (f.exists()) {
            try {
                return new FileInputStream(f);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        if (klass != null) {
            InputStream ins = klass.getClassLoader().getResourceAsStream(path);
            if (ins == null) {
                ins = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
            }
            if (ins != null) {
                return ins;
            }
        }
        return ClassLoader.getSystemResourceAsStream(path);
    }

    public static InputStream findFileAsStream(String path, String enc) {
        return Files.findFileAsStream(path, Files.class, enc);
    }

    public static InputStream findFileAsStream(String path, Class<?> klass) {
        return Files.findFileAsStream(path, klass, Encoding.defaultEncoding());
    }

    public static InputStream findFileAsStream(String path) {
        return Files.findFileAsStream(path, Files.class, Encoding.defaultEncoding());
    }

    public static boolean isDirectory(File f) {
        if (f == null) {
            return false;
        }
        if (!f.exists()) {
            return false;
        }
        return f.isDirectory();
    }

    public static boolean isFile(File f) {
        return f != null && f.exists() && f.isFile();
    }

    public static boolean createNewFile(File f) throws IOException {
        if (f == null || f.exists()) {
            return false;
        }
        Files.makeDir(f.getParentFile());
        return f.createNewFile();
    }

    public static boolean makeDir(File dir) {
        if (dir == null || dir.exists()) {
            return false;
        }
        return dir.mkdirs();
    }

    public static boolean deleteDir(File dir) {
        if (dir == null || !dir.exists()) {
            return false;
        }
        if (!dir.isDirectory()) {
            throw new RuntimeException("\"" + dir.getAbsolutePath() + "\" should be a directory!");
        }
        File[] files = dir.listFiles();
        boolean re = false;
        if (files != null) {
            if (files.length == 0) {
                return dir.delete();
            }
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                re = f.isDirectory() ? (re |= Files.deleteDir(f)) : (re |= Files.deleteFile(f));
                ++n2;
            }
            re |= dir.delete();
        }
        return re;
    }

    public static boolean deleteFile(File f) {
        if (f == null) {
            return false;
        }
        return f.delete();
    }

    public static boolean clearDir(File dir) {
        File[] fs;
        if (dir == null) {
            return false;
        }
        if (!dir.exists()) {
            return false;
        }
        File[] fileArray = fs = dir.listFiles();
        int n = fs.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isFile()) {
                Files.deleteFile(f);
            } else if (f.isDirectory()) {
                Files.deleteDir(f);
            }
            ++n2;
        }
        return false;
    }

    public static boolean copyFile(File src, File target) throws IOException {
        if (src == null || target == null || !src.exists()) {
            return false;
        }
        if (!target.exists() && !Files.createNewFile(target)) {
            return false;
        }
        BufferedInputStream ins = new BufferedInputStream(new FileInputStream(src));
        BufferedOutputStream ops = new BufferedOutputStream(new FileOutputStream(target));
        Streams.write((OutputStream)ops, ins);
        Streams.safeClose(ins);
        Streams.safeFlush(ops);
        Streams.safeClose(ops);
        return target.setLastModified(src.lastModified());
    }

    public static boolean copy(File src, File target) {
        try {
            if (src.isDirectory()) {
                return Files.copyDir(src, target);
            }
            return Files.copyFile(src, target);
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public static boolean copyDir(File src, File target) throws IOException {
        if (src == null || target == null || !src.exists()) {
            return false;
        }
        if (!src.isDirectory()) {
            throw new IOException(String.valueOf(src.getAbsolutePath()) + " should be a directory!");
        }
        if (!target.exists() && !Files.makeDir(target)) {
            return false;
        }
        boolean re = true;
        File[] files = src.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                re = f.isFile() ? (re &= Files.copyFile(f, new File(String.valueOf(target.getAbsolutePath()) + "/" + f.getName()))) : (re &= Files.copyDir(f, new File(String.valueOf(target.getAbsolutePath()) + "/" + f.getName())));
                ++n2;
            }
        }
        return re;
    }

    public static boolean move(File src, File target) throws IOException {
        if (src == null || target == null) {
            return false;
        }
        Files.makeDir(target.getParentFile());
        if (src.isDirectory()) {
            src = new File(String.valueOf(src.getCanonicalPath()) + File.separator);
            target = new File(String.valueOf(target.getCanonicalPath()) + File.separator);
        }
        return src.renameTo(target);
    }

    public static boolean rename(File src, String newName) {
        if (src == null || newName == null) {
            return false;
        }
        if (src.exists()) {
            File newFile = new File(String.valueOf(src.getParent()) + "/" + newName);
            if (newFile.exists()) {
                return false;
            }
            Files.makeDir(newFile.getParentFile());
            return src.renameTo(newFile);
        }
        return false;
    }

    public static String renamePath(String path, String newName) {
        int pos;
        if (!Strings.isBlank(path) && (pos = path.replace('\\', '/').lastIndexOf(47)) > 0) {
            return String.valueOf(path.substring(0, pos)) + "/" + newName;
        }
        return newName;
    }

    public static String getParent(String path) {
        if (Strings.isBlank(path)) {
            return path;
        }
        int pos = path.replace('\\', '/').lastIndexOf(47);
        if (pos > 0) {
            return path.substring(0, pos);
        }
        return "/";
    }

    public static String getName(String path) {
        int pos;
        if (!Strings.isBlank(path) && (pos = path.replace('\\', '/').lastIndexOf(47)) != -1) {
            return path.substring(pos + 1);
        }
        return path;
    }

    public static void cleanAllFolderInSubFolderes(File dir, String name) throws IOException {
        File[] files;
        File[] fileArray = files = dir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File d = fileArray[n2];
            if (d.isDirectory()) {
                if (d.getName().equalsIgnoreCase(name)) {
                    Files.deleteDir(d);
                } else {
                    Files.cleanAllFolderInSubFolderes(d, name);
                }
            }
            ++n2;
        }
    }

    public static boolean isEquals(File f1, File f2) {
        if (f1 == null || f2 == null || !f1.isFile() || !f2.isFile()) {
            return false;
        }
        InputStream ins1 = null;
        InputStream ins2 = null;
        try {
            ins1 = Streams.fileIn(f1);
            ins2 = Streams.fileIn(f2);
            boolean bl = Streams.equals(ins1, ins2);
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
        finally {
            Streams.safeClose(ins1);
            Streams.safeClose(ins2);
        }
    }

    public static File getFile(File dir, String path) {
        if (dir.exists()) {
            if (dir.isDirectory()) {
                return new File(String.valueOf(dir.getAbsolutePath()) + "/" + path);
            }
            return new File(String.valueOf(dir.getParent()) + "/" + path);
        }
        return new File(path);
    }

    public static File[] dirs(File dir) {
        return dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return !f.isHidden() && f.isDirectory() && !f.getName().startsWith(".");
            }
        });
    }

    public static File[] scanDirs(File dir) {
        ArrayList<File> list = new ArrayList<File>();
        list.add(dir);
        Files.scanDirs(dir, list);
        return list.toArray(new File[list.size()]);
    }

    private static void scanDirs(File rootDir, List<File> list) {
        File[] dirs = rootDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return !f.isHidden() && f.isDirectory() && !f.getName().startsWith(".");
            }
        });
        if (dirs != null) {
            File[] fileArray = dirs;
            int n = dirs.length;
            int n2 = 0;
            while (n2 < n) {
                File dir = fileArray[n2];
                Files.scanDirs(dir, list);
                list.add(dir);
                ++n2;
            }
        }
    }

    public static File[] files(File dir, final String suffix) {
        return dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return !f.isHidden() && f.isFile() && (suffix == null || f.getName().endsWith(suffix));
            }
        });
    }

    public static boolean equals(File f1, File f2) {
        return Files.isEquals(f1, f2);
    }

    public static boolean copyOnWrite(File f, Object obj) {
        File tmp = new File(String.valueOf(f.getAbsolutePath()) + ".new");
        File tmp2 = new File(String.valueOf(f.getAbsolutePath()) + ".old");
        tmp2.delete();
        try {
            Files.write(tmp, obj);
            boolean flag = false;
            if (f.exists()) {
                flag = f.renameTo(tmp2);
            }
            if (tmp.renameTo(f)) {
                tmp2.delete();
                return true;
            }
            if (flag) {
                tmp2.renameTo(f);
            }
            return false;
        }
        finally {
            tmp.delete();
        }
    }

    public static boolean copyOnWrite(String path, Object obj) {
        return Files.copyOnWrite(new File(path), obj);
    }

    public static List<String> readLines(File f) {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader br = null;
        try {
            try {
                br = Streams.buffr(Streams.fileInr(f));
                while (br.ready()) {
                    lines.add(br.readLine());
                }
            }
            catch (IOException e) {
                throw Lang.wrapThrow(e);
            }
        }
        catch (Throwable throwable) {
            Streams.safeClose(br);
            throw throwable;
        }
        Streams.safeClose(br);
        return lines;
    }

    public static void readLine(File f, Callback<String> callback) {
        block7: {
            BufferedReader br = null;
            try {
                br = Streams.buffr(Streams.fileInr(f));
                while (br.ready()) {
                    callback.invoke(br.readLine());
                }
            }
            catch (ExitLoop exitLoop) {
                Streams.safeClose(br);
                break block7;
            }
            catch (IOException e) {
                try {
                    throw Lang.wrapThrow(e);
                }
                catch (Throwable throwable) {
                    Streams.safeClose(br);
                    throw throwable;
                }
            }
            Streams.safeClose(br);
        }
    }
}

