/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.nutz.lang.InvokingException;
import org.nutz.lang.Lang;
import org.nutz.lang.MatchType;
import org.nutz.lang.Mirror;

public class Invoking {
    private String msg;
    private Invoker invoker;

    public Invoking(Class<?> type, String methodName, Object ... args) {
        block14: {
            try {
                Class<?>[] pts;
                if (args == null || args.length == 0) {
                    this.invoker = new NullArgInvoker(type.getMethod(methodName, new Class[0]));
                    break block14;
                }
                Method[] all = type.getMethods();
                ArrayList<Method> candidates = new ArrayList<Method>(all.length);
                Method[] methodArray = all;
                int n = all.length;
                int n2 = 0;
                while (n2 < n) {
                    Method m = methodArray[n2];
                    if (m.getName().equals(methodName)) {
                        candidates.add(m);
                    }
                    ++n2;
                }
                Class<?>[] argTypes = Mirror.evalToTypes(args);
                Object dynaArg = Mirror.evalArgToRealArray(args);
                for (Method m : candidates) {
                    pts = m.getParameterTypes();
                    MatchType mr = Mirror.matchParamTypes(pts, argTypes);
                    if (MatchType.YES == mr) {
                        this.invoker = new DefaultInvoker(m, args);
                        break;
                    }
                    if (MatchType.LACK == mr) {
                        this.invoker = new DefaultInvoker(m, Lang.arrayLast(args, Mirror.blankArrayArg(pts)));
                        break;
                    }
                    if (dynaArg == null || pts.length != 1) continue;
                    if (pts[0] == dynaArg.getClass()) {
                        this.invoker = new DynamicArgsInvoker(m, Lang.array2array(args, pts[0].getComponentType()));
                        break;
                    }
                    if (!pts[0].isArray() || !Mirror.me(pts[0].getComponentType()).getWrapper().equals(Mirror.me(dynaArg.getClass().getComponentType()).getWrapper())) continue;
                    this.invoker = new DynamicArgsInvoker(m, Lang.array2array(args, pts[0].getComponentType()));
                    break;
                }
                if (this.invoker != null) break block14;
                try {
                    for (Method m : candidates) {
                        pts = m.getParameterTypes();
                        if (pts.length == args.length) {
                            this.invoker = new DefaultInvoker(m, Lang.array2ObjectArray(args, pts));
                            continue;
                        }
                        if (pts.length != args.length + 1 || !pts[args.length].isArray()) continue;
                        this.invoker = new DefaultInvoker(m, Lang.array2ObjectArray(args, pts));
                    }
                }
                catch (Exception exception) {}
            }
            catch (NoSuchMethodException e) {
                throw Lang.wrapThrow(e);
            }
        }
        if (this.invoker == null) {
            throw new InvokingException("Don't know how to invoke [%s].%s() by args:\n %s", type.getName(), methodName, Lang.concat((Object)Character.valueOf('\n'), args));
        }
        this.msg = String.valueOf(String.format("Fail to invoke [%s].%s() by args:\n %s", type.getName(), methodName, Lang.concat((Object)Character.valueOf('\n'), args))) + "\nFor the reason: %s";
    }

    public Object invoke(Object obj) {
        try {
            return this.invoker.invoke(obj);
        }
        catch (Throwable e) {
            throw new InvokingException(this.msg, Lang.unwrapThrow(e));
        }
    }

    private static class DefaultInvoker
    extends Invoker {
        private Object[] args;

        public DefaultInvoker(Method method, Object[] args) {
            super(method);
            this.args = args;
        }

        @Override
        Object invoke(Object obj) throws Exception {
            return this.method.invoke(obj, this.args);
        }
    }

    private static class DynamicArgsInvoker
    extends Invoker {
        private Object args;

        public DynamicArgsInvoker(Method method, Object args) {
            super(method);
            this.args = args;
        }

        @Override
        Object invoke(Object obj) throws Exception {
            return this.method.invoke(obj, this.args);
        }
    }

    private static abstract class Invoker {
        protected Method method;

        public Invoker(Method method) {
            this.method = method;
        }

        abstract Object invoke(Object var1) throws Exception;
    }

    private static class NullArgInvoker
    extends Invoker {
        public NullArgInvoker(Method method) {
            super(method);
        }

        @Override
        Object invoke(Object obj) throws Exception {
            return this.method.invoke(obj, new Object[0]);
        }
    }
}

