/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nutz.castor.Castors;
import org.nutz.castor.FailToCastObjectException;
import org.nutz.lang.FailToGetValueException;
import org.nutz.lang.FailToSetValueException;
import org.nutz.lang.Invoking;
import org.nutz.lang.Lang;
import org.nutz.lang.MatchType;
import org.nutz.lang.Strings;
import org.nutz.lang.TypeExtractor;
import org.nutz.lang.born.BornContext;
import org.nutz.lang.born.Borning;
import org.nutz.lang.born.BorningException;
import org.nutz.lang.born.Borns;
import org.nutz.lang.eject.EjectByField;
import org.nutz.lang.eject.EjectByGetter;
import org.nutz.lang.eject.Ejecting;
import org.nutz.lang.inject.InjectByField;
import org.nutz.lang.inject.InjectBySetter;
import org.nutz.lang.inject.Injecting;
import org.nutz.lang.util.Callback;
import org.nutz.lang.util.Callback3;

public class Mirror<T> {
    private static final DefaultTypeExtractor defaultTypeExtractor = new DefaultTypeExtractor();
    private Class<T> klass;
    private Type type;
    private TypeExtractor typeExtractor;
    private String _type_id;
    private static final Pattern PTN = Pattern.compile("(<)(.+)(>)");
    private static final Map<Class<?>, Class<?>> TypeMapping2 = new HashMap();

    static {
        TypeMapping2.put(Short.class, Short.TYPE);
        TypeMapping2.put(Integer.class, Integer.TYPE);
        TypeMapping2.put(Long.class, Long.TYPE);
        TypeMapping2.put(Double.class, Double.TYPE);
        TypeMapping2.put(Float.class, Float.TYPE);
        TypeMapping2.put(Byte.class, Byte.TYPE);
        TypeMapping2.put(Character.class, Character.TYPE);
        TypeMapping2.put(Boolean.class, Boolean.TYPE);
    }

    public static <T> Mirror<T> me(Class<T> classOfT) {
        return classOfT == null ? null : new Mirror<T>(classOfT).setTypeExtractor(defaultTypeExtractor);
    }

    public static <T> Mirror<T> me(T obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Class) {
            return Mirror.me((Class)obj);
        }
        return Mirror.me(obj.getClass());
    }

    public static <T> Mirror<T> me(Class<T> classOfT, TypeExtractor typeExtractor) {
        return classOfT == null ? null : new Mirror<T>(classOfT).setTypeExtractor(typeExtractor == null ? defaultTypeExtractor : typeExtractor);
    }

    public static <T> Mirror<T> me(Type type) {
        if (type == null) {
            return null;
        }
        Mirror<Class<?>> mir = Mirror.me(Lang.getTypeClass(type));
        mir.type = type;
        return mir;
    }

    public Mirror<T> setTypeExtractor(TypeExtractor typeExtractor) {
        this.typeExtractor = typeExtractor;
        return this;
    }

    private Mirror(Class<T> classOfT) {
        this.klass = classOfT;
    }

    public Method getGetter(String fieldName) throws NoSuchMethodException {
        String fn = Strings.upperFirst(fieldName);
        String _get = "get" + fn;
        String _is = "is" + fn;
        Method[] methodArray = this.klass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getParameterTypes().length == 0) {
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                if (_get.equals(method.getName())) {
                    return method;
                }
                if (_is.equals(method.getName())) {
                    if (!Mirror.me(method.getReturnType()).isBoolean()) {
                        throw new NoSuchMethodException();
                    }
                    return method;
                }
                if (fieldName.equals(method.getName())) {
                    return method;
                }
            }
            ++n2;
        }
        throw Lang.makeThrow(NoSuchMethodException.class, "Fail to find getter for [%s]->[%s]", this.klass.getName(), fieldName);
    }

    public Method getGetter(Field field) throws NoSuchMethodException {
        return this.getGetter(field.getName());
    }

    public static void evalGetterSetter(Method method, Callback3<String, Method, Method> callback, Callback<Method> whenError) {
        String name = method.getName();
        Method getter = null;
        Method setter = null;
        if (name.startsWith("get") && method.getParameterTypes().length == 0) {
            name = Strings.lowerFirst(name.substring(3));
            getter = method;
            try {
                setter = method.getDeclaringClass().getMethod("set" + Strings.upperFirst(name), method.getReturnType());
            }
            catch (Exception exception) {}
        } else if (name.startsWith("is") && Mirror.me(method.getReturnType()).isBoolean() && method.getParameterTypes().length == 0) {
            name = Strings.lowerFirst(name.substring(2));
            getter = method;
            try {
                setter = method.getDeclaringClass().getMethod("set" + Strings.upperFirst(name), method.getReturnType());
            }
            catch (Exception exception) {}
        } else if (name.startsWith("set") && method.getParameterTypes().length == 1) {
            name = Strings.lowerFirst(name.substring(3));
            setter = method;
            try {
                getter = method.getDeclaringClass().getMethod("get" + Strings.upperFirst(name), new Class[0]);
            }
            catch (Exception exception) {}
        } else {
            if (whenError != null) {
                whenError.invoke(method);
            }
            return;
        }
        if (callback != null) {
            callback.invoke(name, getter, setter);
        }
    }

    public static void evalGetterSetter(Method method, final String errmsgFormat, Callback3<String, Method, Method> callback) {
        Mirror.evalGetterSetter(method, callback, new Callback<Method>(){

            @Override
            public void invoke(Method method) {
                throw Lang.makeThrow(errmsgFormat, method.getName(), method.getDeclaringClass().getName());
            }
        });
    }

    public Method getSetter(Field field) throws NoSuchMethodException {
        return this.getSetter(field.getName(), field.getType());
    }

    /*
     * Unable to fully structure code
     */
    public Method getSetter(String fieldName, Class<?> paramType) throws NoSuchMethodException {
        try {
            setterName = "set" + Strings.upperFirst(fieldName);
            try {
                return this.klass.getMethod(setterName, new Class[]{paramType});
            }
            catch (Throwable v0) {
                try {
                    return this.klass.getMethod(fieldName, new Class[]{paramType});
                }
                catch (Throwable v1) {
                    type = Mirror.me(paramType);
                    var8_5 = this.klass.getMethods();
                    var7_6 = var8_5.length;
                    var6_7 = 0;
                    ** while (var6_7 < var7_6)
                }
            }
lbl-1000:
            // 1 sources

            {
                method = var8_5[var6_7];
                if (method.getParameterTypes().length == 1 && (method.getName().equals(setterName) || method.getName().equals(fieldName)) && (paramType == null || type.canCastToDirectly(method.getParameterTypes()[0]))) {
                    return method;
                }
                ++var6_7;
                continue;
            }
lbl19:
            // 1 sources

            if (!paramType.isPrimitive() && (p = this.unWrapper()) != null) {
                return this.getSetter(fieldName, p);
            }
            throw new RuntimeException();
        }
        catch (Throwable v2) {
            throw Lang.makeThrow(NoSuchMethodException.class, "Fail to find setter for [%s]->[%s(%s)]", new Object[]{this.klass.getName(), fieldName, paramType.getName()});
        }
    }

    public Method[] findSetters(String fieldName) {
        String mName = "set" + Strings.upperFirst(fieldName);
        ArrayList<Method> ms = new ArrayList<Method>();
        Method[] methodArray = this.klass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (!Modifier.isStatic(m.getModifiers()) && m.getParameterTypes().length == 1 && m.getName().equals(mName)) {
                ms.add(m);
            }
            ++n2;
        }
        return ms.toArray(new Method[ms.size()]);
    }

    public Field getField(String name) throws NoSuchFieldException {
        Class<T> cc = this.klass;
        while (cc != null && cc != Object.class) {
            try {
                return cc.getDeclaredField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                cc = cc.getSuperclass();
            }
        }
        throw new NoSuchFieldException(String.format("Can NOT find field [%s] in class [%s] and it's parents classes", name, this.klass.getName()));
    }

    public <AT extends Annotation> Field getField(Class<AT> ann) throws NoSuchFieldException {
        Field[] fieldArray = this.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.isAnnotationPresent(ann)) {
                return field;
            }
            ++n2;
        }
        throw new NoSuchFieldException(String.format("Can NOT find field [@%s] in class [%s] and it's parents classes", ann.getName(), this.klass.getName()));
    }

    public <AT extends Annotation> Field[] getFields(Class<AT> ann) {
        LinkedList<Field> fields = new LinkedList<Field>();
        Field[] fieldArray = this.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (f.isAnnotationPresent(ann)) {
                fields.add(f);
            }
            ++n2;
        }
        return fields.toArray(new Field[fields.size()]);
    }

    public Field[] getFields() {
        return this._getFields(true, false, true, true);
    }

    public Field[] getStaticField(boolean noFinal) {
        return this._getFields(false, true, noFinal, true);
    }

    private Field[] _getFields(boolean noStatic, boolean noMember, boolean noFinal, boolean noInner) {
        Class<T> cc = this.klass;
        LinkedHashMap<String, Field> map = new LinkedHashMap<String, Field>();
        while (cc != null && cc != Object.class) {
            Field[] fs = cc.getDeclaredFields();
            int i = 0;
            while (i < fs.length) {
                Field f = fs[i];
                int m = f.getModifiers();
                if (!(noStatic && Modifier.isStatic(m) || noFinal && Modifier.isFinal(m) || noInner && f.getName().startsWith("this$") || noMember && !Modifier.isStatic(m) || map.containsKey(fs[i].getName()))) {
                    map.put(fs[i].getName(), fs[i]);
                }
                ++i;
            }
            cc = cc.getSuperclass();
        }
        return map.values().toArray(new Field[map.size()]);
    }

    public <A extends Annotation> A getAnnotation(Class<A> annType) {
        A ann;
        Class<T> cc = this.klass;
        do {
            ann = cc.getAnnotation(annType);
            cc = cc.getSuperclass();
        } while (ann == null && cc != Object.class);
        return ann;
    }

    public Type[] getGenericsTypes() {
        if (this.type instanceof ParameterizedType) {
            return Lang.getGenericsTypes(this.type);
        }
        return null;
    }

    public Type getGenericsType(int index) {
        Type[] ts = this.getGenericsTypes();
        return ts == null ? null : (ts.length <= index ? null : ts[index]);
    }

    public Method[] getMethods() {
        Class<T> cc = this.klass;
        LinkedList<Method> list = new LinkedList<Method>();
        while (cc != null && cc != Object.class) {
            Method[] ms = cc.getDeclaredMethods();
            int i = 0;
            while (i < ms.length) {
                list.add(ms[i]);
                ++i;
            }
            cc = cc.getSuperclass();
        }
        return list.toArray(new Method[list.size()]);
    }

    public Method[] getAllDeclaredMethods(Class<?> top) {
        Class<T> cc = this.klass;
        LinkedHashMap<String, Method> map = new LinkedHashMap<String, Method>();
        while (cc != null && cc != Object.class) {
            Method[] fs = cc.getDeclaredMethods();
            int i = 0;
            while (i < fs.length) {
                String key = String.valueOf(fs[i].getName()) + Mirror.getParamDescriptor(fs[i].getParameterTypes());
                if (!map.containsKey(key)) {
                    map.put(key, fs[i]);
                }
                ++i;
            }
            Class<T> clazz = cc = cc.getSuperclass() == top ? null : cc.getSuperclass();
        }
        return map.values().toArray(new Method[map.size()]);
    }

    public Method[] getAllDeclaredMethodsWithoutTop() {
        return this.getAllDeclaredMethods(Object.class);
    }

    public Method[] getStaticMethods() {
        LinkedList<Method> list = new LinkedList<Method>();
        Method[] methodArray = this.klass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (Modifier.isStatic(m.getModifiers()) && Modifier.isPublic(m.getModifiers())) {
                list.add(m);
            }
            ++n2;
        }
        return list.toArray(new Method[list.size()]);
    }

    private static RuntimeException makeSetValueException(Class<?> type, String name, Object value, Exception e) {
        if (e instanceof FailToSetValueException) {
            return (FailToSetValueException)e;
        }
        return new FailToSetValueException(String.format("Fail to set value [%s] to [%s]->[%s] because '%s'", value, type.getName(), name, e.getMessage()), e);
    }

    public void setValue(Object obj, Field field, Object value) throws FailToSetValueException {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        Class<?> ft = field.getType();
        if (value != null) {
            if (!field.getType().isAssignableFrom(value.getClass())) {
                try {
                    value = Castors.me().castTo(value, field.getType());
                }
                catch (FailToCastObjectException e) {
                    throw Mirror.makeSetValueException(obj.getClass(), field.getName(), value, e);
                }
            }
        } else if (ft.isPrimitive()) {
            value = Boolean.TYPE == ft ? Boolean.valueOf(false) : (Character.TYPE == ft ? (Comparable<Character>)Character.valueOf('\u0000') : (Comparable<Character>)Byte.valueOf((byte)0));
        }
        try {
            this.getSetter(field).invoke(obj, value);
        }
        catch (Exception exception) {
            try {
                field.set(obj, value);
            }
            catch (Exception e) {
                throw Mirror.makeSetValueException(obj.getClass(), field.getName(), value, e);
            }
        }
    }

    public void setValue(Object obj, String fieldName, Object value) throws FailToSetValueException {
        if (value == null) {
            try {
                this.setValue(obj, this.getField(fieldName), null);
            }
            catch (Exception e1) {
                throw Mirror.makeSetValueException(obj.getClass(), fieldName, null, e1);
            }
        }
        try {
            this.getSetter(fieldName, value.getClass()).invoke(obj, value);
        }
        catch (Exception exception) {
            try {
                this.setValue(obj, this.getField(fieldName), value);
            }
            catch (Exception e1) {
                throw Mirror.makeSetValueException(obj.getClass(), fieldName, value, e1);
            }
        }
    }

    private static RuntimeException makeGetValueException(Class<?> type, String name, Throwable e) {
        return new FailToGetValueException(String.format("Fail to get value for [%s]->[%s]", type.getName(), name), e);
    }

    public Object getValue(Object obj, Field f) throws FailToGetValueException {
        if (!f.isAccessible()) {
            f.setAccessible(true);
        }
        try {
            return f.get(obj);
        }
        catch (Exception e) {
            throw Mirror.makeGetValueException(obj.getClass(), f.getName(), e);
        }
    }

    public Object getValue(Object obj, String name) throws FailToGetValueException {
        try {
            return this.getGetter(name).invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            try {
                return this.getValue(obj, this.getField(name));
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (obj != null && obj.getClass().isArray() && "length".equals(name)) {
                    return Lang.length(obj);
                }
                throw Mirror.makeGetValueException(obj.getClass(), name, e);
            }
        }
    }

    public Class<T> getType() {
        return this.klass;
    }

    public String getTypeId() {
        if (this._type_id == null) {
            if (this.type != null && this.type instanceof ParameterizedType) {
                ParameterizedType pmType = (ParameterizedType)this.type;
                ArrayList<Type> list = new ArrayList<Type>(pmType.getActualTypeArguments().length);
                Type[] typeArray = pmType.getActualTypeArguments();
                int n = typeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Type pmA = typeArray[n2];
                    list.add(pmA);
                    ++n2;
                }
                this._type_id = String.format("%s<%s>", this.klass.getName(), Lang.concat((Object)",", list));
            } else {
                this._type_id = this.klass.getName();
            }
            this._type_id = String.valueOf(this._type_id) + "_" + this.klass.getClassLoader();
        }
        return this._type_id;
    }

    public Type getActuallyType() {
        return this.type == null ? this.klass : this.type;
    }

    public Class<?>[] extractTypes() {
        return this.typeExtractor.extract(this);
    }

    public Class<?> getWrapperClass() {
        if (!this.klass.isPrimitive()) {
            if (this.isPrimitiveNumber() || this.is(Boolean.class) || this.is(Character.class)) {
                return this.klass;
            }
            throw Lang.makeThrow("Class '%s' should be a primitive class", this.klass.getName());
        }
        if (this.is(Integer.TYPE)) {
            return Integer.class;
        }
        if (this.is(Character.TYPE)) {
            return Character.class;
        }
        if (this.is(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (this.is(Long.TYPE)) {
            return Long.class;
        }
        if (this.is(Float.TYPE)) {
            return Float.class;
        }
        if (this.is(Byte.TYPE)) {
            return Byte.class;
        }
        if (this.is(Short.TYPE)) {
            return Short.class;
        }
        if (this.is(Double.TYPE)) {
            return Double.class;
        }
        throw Lang.makeThrow("Class [%s] has no wrapper class!", this.klass.getName());
    }

    public Class<?> getWrapper() {
        if (this.klass.isPrimitive()) {
            return this.getWrapperClass();
        }
        return this.klass;
    }

    public Class<?> getOuterClass() {
        if (Modifier.isStatic(this.klass.getModifiers())) {
            return null;
        }
        String name = this.klass.getName();
        int pos = name.lastIndexOf(36);
        if (pos == -1) {
            return null;
        }
        name = name.substring(0, pos);
        try {
            return Lang.loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public Borning<T> getBorning(Object ... args) throws BorningException {
        BornContext<T> bc = Borns.eval(this.klass, args);
        if (bc == null) {
            throw new BorningException(this.klass, args);
        }
        return bc.getBorning();
    }

    public Borning<T> getBorningByArgTypes(Class<?> ... argTypes) throws BorningException {
        BornContext<T> bc = Borns.evalByArgTypes(this.klass, argTypes);
        if (bc == null) {
            throw new BorningException(this.klass, argTypes);
        }
        return bc.getBorning();
    }

    public T born(Object ... args) {
        BornContext<T> bc = Borns.eval(this.klass, args);
        if (bc == null) {
            throw new BorningException(this.klass, args);
        }
        return bc.doBorn();
    }

    private static boolean doMatchMethodParamsType(Class<?>[] paramTypes, Class<?>[] methodArgTypes) {
        if (paramTypes.length == 0 && methodArgTypes.length == 0) {
            return true;
        }
        if (paramTypes.length == methodArgTypes.length) {
            int i = 0;
            while (i < paramTypes.length) {
                if (!Mirror.me(paramTypes[i]).canCastToDirectly(methodArgTypes[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (paramTypes.length + 1 == methodArgTypes.length) {
            if (!methodArgTypes[paramTypes.length].isArray()) {
                return false;
            }
            int i = 0;
            while (i < paramTypes.length) {
                if (!Mirror.me(paramTypes[i]).canCastToDirectly(methodArgTypes[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public Invoking getInvoking(String methodName, Object ... args) {
        return new Invoking(this.klass, methodName, args);
    }

    public Injecting getInjecting(String fieldName) {
        Method[] sss = this.findSetters(fieldName);
        if (sss.length == 1) {
            return new InjectBySetter(sss[0]);
        }
        try {
            Field field = this.getField(fieldName);
            try {
                return new InjectBySetter(this.getSetter(field));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return new InjectByField(field);
            }
        }
        catch (NoSuchFieldException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public Ejecting getEjecting(String fieldName) {
        try {
            return new EjectByGetter(this.getGetter(fieldName));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                Field field = this.getField(fieldName);
                try {
                    return new EjectByGetter(this.getGetter(field));
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    return new EjectByField(field);
                }
            }
            catch (NoSuchFieldException e1) {
                throw Lang.wrapThrow(e1);
            }
        }
    }

    public Object invoke(Object obj, String methodName, Object ... args) {
        return this.getInvoking(methodName, args).invoke(obj);
    }

    /*
     * Unable to fully structure code
     */
    public Method findMethod(String name, Class<?> ... paramTypes) throws NoSuchMethodException {
        try {
            return this.klass.getMethod(name, paramTypes);
        }
        catch (NoSuchMethodException v0) {
            var6_3 = this.klass.getMethods();
            var5_4 = var6_3.length;
            var4_5 = 0;
            ** while (var4_5 < var5_4)
        }
lbl-1000:
        // 1 sources

        {
            m = var6_3[var4_5];
            if (m.getName().equals(name) && Mirror.doMatchMethodParamsType(paramTypes, m.getParameterTypes())) {
                return m;
            }
            ++var4_5;
            continue;
        }
lbl13:
        // 1 sources

        throw new NoSuchMethodException(String.format("Fail to find Method %s->%s with params:\n%s", new Object[]{this.klass.getName(), name, Castors.me().castToString(paramTypes)}));
    }

    public Method[] findMethods(String name, int argNumber) {
        LinkedList<Method> methods = new LinkedList<Method>();
        Method[] methodArray = this.klass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equals(name)) {
                if (argNumber < 0) {
                    methods.add(m);
                } else if (m.getParameterTypes().length == argNumber) {
                    methods.add(m);
                }
            }
            ++n2;
        }
        return methods.toArray(new Method[methods.size()]);
    }

    public Method findMethod(Class<?> returnType, Class<?> ... paramTypes) throws NoSuchMethodException {
        Method[] methodArray = this.klass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (returnType == m.getReturnType() && paramTypes.length == m.getParameterTypes().length) {
                boolean noThisOne = false;
                int i = 0;
                while (i < paramTypes.length) {
                    if (paramTypes[i] != m.getParameterTypes()[i]) {
                        noThisOne = true;
                        break;
                    }
                    ++i;
                }
                if (!noThisOne) {
                    return m;
                }
            }
            ++n2;
        }
        throw new NoSuchMethodException(String.format("Can not find method in [%s] with return type '%s' and arguemtns \n'%s'!", this.klass.getName(), returnType.getName(), Castors.me().castToString(paramTypes)));
    }

    public static MatchType matchParamTypes(Class<?>[] methodParamTypes, Object ... args) {
        return Mirror.matchParamTypes(methodParamTypes, Mirror.evalToTypes(args));
    }

    public static Class<?>[] evalToTypes(Object ... args) {
        Class[] types = new Class[args.length];
        int i = 0;
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            types[i++] = arg == null ? Object.class : arg.getClass();
            ++n2;
        }
        return types;
    }

    public static Object evalArgToSameTypeRealArray(Object ... args) {
        Object array = Mirror.evalArgToRealArray(args);
        return array == args ? null : array;
    }

    public static Object evalArgToRealArray(Object ... args) {
        if (args == null || args.length == 0 || args[0] == null) {
            return null;
        }
        Object re = null;
        Class<?> type = null;
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            if (arg == null) break;
            if (type == null) {
                type = arg.getClass();
            } else if (arg.getClass() != type) {
                type = null;
                break;
            }
            ++n2;
        }
        if (type != null) {
            re = Array.newInstance(type, args.length);
            int i = 0;
            while (i < args.length) {
                Array.set(re, i, args[i]);
                ++i;
            }
            return re;
        }
        return args;
    }

    public static MatchType matchParamTypes(Class<?>[] paramTypes, Class<?>[] argTypes) {
        int len;
        int n = len = argTypes == null ? 0 : argTypes.length;
        if (len == 0 && paramTypes.length == 0) {
            return MatchType.YES;
        }
        if (paramTypes.length == len) {
            int i = 0;
            while (i < len) {
                if (!Mirror.me(argTypes[i]).canCastToDirectly(paramTypes[i])) {
                    return MatchType.NO;
                }
                ++i;
            }
            return MatchType.YES;
        }
        if (len + 1 == paramTypes.length) {
            if (!paramTypes[len].isArray()) {
                return MatchType.NO;
            }
            int i = 0;
            while (i < len) {
                if (!Mirror.me(argTypes[i]).canCastToDirectly(paramTypes[i])) {
                    return MatchType.NO;
                }
                ++i;
            }
            return MatchType.LACK;
        }
        return MatchType.NO;
    }

    public boolean is(Class<?> type) {
        return type != null && this.klass == type;
    }

    public boolean is(String className) {
        return this.klass.getName().equals(className);
    }

    public boolean isOf(Class<?> type) {
        return type.isAssignableFrom(this.klass);
    }

    public boolean isString() {
        return this.is(String.class);
    }

    public boolean isStringLike() {
        return CharSequence.class.isAssignableFrom(this.klass);
    }

    public boolean isSimple() {
        return this.isStringLike() || this.isBoolean() || this.isChar() || this.isNumber() || this.isDateTimeLike();
    }

    public boolean isChar() {
        return this.is(Character.TYPE) || this.is(Character.class);
    }

    public boolean isEnum() {
        return this.klass.isEnum();
    }

    public boolean isBoolean() {
        return this.is(Boolean.TYPE) || this.is(Boolean.class);
    }

    public boolean isFloat() {
        return this.is(Float.TYPE) || this.is(Float.class);
    }

    public boolean isDouble() {
        return this.is(Double.TYPE) || this.is(Double.class);
    }

    public boolean isInt() {
        return this.is(Integer.TYPE) || this.is(Integer.class);
    }

    public boolean isIntLike() {
        return this.isInt() || this.isLong() || this.isShort() || this.isByte() || this.is(BigDecimal.class);
    }

    public boolean isInterface() {
        return this.klass.isInterface();
    }

    public boolean isDecimal() {
        return this.isFloat() || this.isDouble();
    }

    public boolean isLong() {
        return this.is(Long.TYPE) || this.is(Long.class);
    }

    public boolean isShort() {
        return this.is(Short.TYPE) || this.is(Short.class);
    }

    public boolean isByte() {
        return this.is(Byte.TYPE) || this.is(Byte.class);
    }

    public boolean isWrapperOf(Class<?> type) {
        try {
            return Mirror.me(type).getWrapperClass() == this.klass;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean canCastToDirectly(Class<?> type) {
        if (this.klass == type || type.isAssignableFrom(this.klass)) {
            return true;
        }
        if (this.klass.isPrimitive() && type.isPrimitive() && this.isPrimitiveNumber() && Mirror.me(type).isPrimitiveNumber()) {
            return true;
        }
        try {
            return Mirror.me(type).getWrapperClass() == this.getWrapperClass();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isPrimitiveNumber() {
        return this.isInt() || this.isLong() || this.isFloat() || this.isDouble() || this.isByte() || this.isShort();
    }

    public boolean isObj() {
        return this.isContainer() || this.isPojo();
    }

    public boolean isPojo() {
        if (this.klass.isPrimitive() || this.isEnum()) {
            return false;
        }
        if (this.isStringLike() || this.isDateTimeLike()) {
            return false;
        }
        if (this.isPrimitiveNumber() || this.isBoolean() || this.isChar()) {
            return false;
        }
        return !this.isContainer();
    }

    public boolean isContainer() {
        return this.isColl() || this.isMap();
    }

    public boolean isArray() {
        return this.klass.isArray();
    }

    public boolean isCollection() {
        return this.isOf(Collection.class);
    }

    public boolean isColl() {
        return this.isArray() || this.isCollection();
    }

    public boolean isMap() {
        return this.isOf(Map.class);
    }

    public boolean isNumber() {
        return Number.class.isAssignableFrom(this.klass) || this.klass.isPrimitive() && !this.is(Boolean.TYPE) && !this.is(Character.TYPE);
    }

    public boolean isDateTimeLike() {
        return Calendar.class.isAssignableFrom(this.klass) || java.util.Date.class.isAssignableFrom(this.klass) || Date.class.isAssignableFrom(this.klass) || Time.class.isAssignableFrom(this.klass);
    }

    public String toString() {
        return this.klass.getName();
    }

    public static Object blankArrayArg(Class<?>[] pts) {
        return Array.newInstance(pts[pts.length - 1].getComponentType(), 0);
    }

    public static Type[] getTypeParams(Class<?> klass) {
        Type[] interfaces;
        if (klass == null || "java.lang.Object".equals(klass.getName())) {
            return null;
        }
        Type superclass = klass.getGenericSuperclass();
        if (superclass != null && superclass instanceof ParameterizedType) {
            return ((ParameterizedType)superclass).getActualTypeArguments();
        }
        Type[] typeArray = interfaces = klass.getGenericInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Type inf = typeArray[n2];
            if (inf instanceof ParameterizedType) {
                return ((ParameterizedType)inf).getActualTypeArguments();
            }
            ++n2;
        }
        return Mirror.getTypeParams(klass.getSuperclass());
    }

    public static Class<?>[] getGenericTypes(Field f) {
        String s;
        String[] ss;
        String gts = f.toGenericString();
        Matcher m = PTN.matcher(gts);
        if (m.find() && (ss = Strings.splitIgnoreBlank(s = m.group(2))).length > 0) {
            Class[] re = new Class[ss.length];
            try {
                int i = 0;
                while (i < ss.length) {
                    int pos;
                    String className = ss[i];
                    re[i] = className.length() > 0 && className.charAt(0) == '?' ? Object.class : ((pos = className.indexOf(60)) < 0 ? Lang.loadClass(className) : Lang.loadClass(className.substring(0, pos)));
                    ++i;
                }
                return re;
            }
            catch (ClassNotFoundException e) {
                throw Lang.wrapThrow(e);
            }
        }
        return new Class[0];
    }

    public static Class<?> getGenericTypes(Field f, int index) {
        Class<?>[] types = Mirror.getGenericTypes(f);
        if (types == null || types.length <= index) {
            return null;
        }
        return types[index];
    }

    public static <T> Class<T> getTypeParam(Class<?> klass, int index) {
        Type[] types = Mirror.getTypeParams(klass);
        if (index >= 0 && index < types.length) {
            Type t = types[index];
            Class<?> clazz = Lang.getTypeClass(t);
            if (clazz == null) {
                throw Lang.makeThrow("Type '%s' is not a Class", t.toString());
            }
            return clazz;
        }
        throw Lang.makeThrow("Class type param out of range %d/%d", index, types.length);
    }

    public static String getPath(Class<?> klass) {
        return klass.getName().replace('.', '/');
    }

    public static String getParamDescriptor(Class<?>[] parameterTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        Class<?>[] classArray = parameterTypes;
        int n = parameterTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> pt = classArray[n2];
            sb.append(Mirror.getTypeDescriptor(pt));
            ++n2;
        }
        sb.append(')');
        String s = sb.toString();
        return s;
    }

    public static String getMethodDescriptor(Method method) {
        return String.valueOf(Mirror.getParamDescriptor(method.getParameterTypes())) + Mirror.getTypeDescriptor(method.getReturnType());
    }

    public static String getConstructorDescriptor(Constructor<?> c) {
        return String.valueOf(Mirror.getParamDescriptor(c.getParameterTypes())) + "V";
    }

    public static String getTypeDescriptor(Class<?> klass) {
        if (klass.isPrimitive()) {
            if (klass == Void.TYPE) {
                return "V";
            }
            if (klass == Integer.TYPE) {
                return "I";
            }
            if (klass == Long.TYPE) {
                return "J";
            }
            if (klass == Byte.TYPE) {
                return "B";
            }
            if (klass == Short.TYPE) {
                return "S";
            }
            if (klass == Float.TYPE) {
                return "F";
            }
            if (klass == Double.TYPE) {
                return "D";
            }
            if (klass == Character.TYPE) {
                return "C";
            }
            return "Z";
        }
        StringBuilder sb = new StringBuilder();
        if (klass.isArray()) {
            return sb.append('[').append(Mirror.getTypeDescriptor(klass.getComponentType())).toString();
        }
        return sb.append('L').append(Mirror.getPath(klass)).append(';').toString();
    }

    public static Field findField(Class<?> type, Class<? extends Annotation> ann) {
        Mirror<Class<?>> mirror = Mirror.me(type);
        Field[] fieldArray = mirror.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (f.isAnnotationPresent(ann)) {
                return f;
            }
            ++n2;
        }
        return null;
    }

    public Class<?> unWrapper() {
        return TypeMapping2.get(this.klass);
    }

    private static class DefaultTypeExtractor
    implements TypeExtractor {
        private DefaultTypeExtractor() {
        }

        @Override
        public Class<?>[] extract(Mirror<?> mirror) {
            Class<?> theType = mirror.getType();
            ArrayList re = new ArrayList(5);
            if (theType.isPrimitive()) {
                re.add(mirror.getWrapperClass());
                if (theType != Boolean.TYPE && theType != Character.TYPE) {
                    re.add(Number.class);
                }
            } else if (mirror.isOf(Calendar.class)) {
                re.add(Calendar.class);
            } else {
                re.add(theType);
                if (((Mirror)mirror).klass.isEnum()) {
                    re.add(Enum.class);
                } else if (((Mirror)mirror).klass.isArray()) {
                    re.add(Array.class);
                } else if (mirror.isStringLike()) {
                    re.add(CharSequence.class);
                } else if (mirror.isNumber()) {
                    re.add(Number.class);
                } else if (mirror.isOf(Map.class)) {
                    re.add(Map.class);
                } else if (mirror.isOf(List.class)) {
                    re.add(List.class);
                    re.add(Collection.class);
                } else if (mirror.isOf(Collection.class)) {
                    re.add(Collection.class);
                }
            }
            if (theType != Object.class) {
                re.add(Object.class);
            }
            return re.toArray(new Class[re.size()]);
        }
    }
}

