/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang;

import java.sql.Timestamp;

public class Stopwatch {
    private boolean nano;
    private long from;
    private long to;

    public static Stopwatch begin() {
        Stopwatch sw = new Stopwatch();
        sw.start();
        return sw;
    }

    public static Stopwatch beginNano() {
        Stopwatch sw = new Stopwatch();
        sw.nano = true;
        sw.start();
        return sw;
    }

    public static Stopwatch create() {
        return new Stopwatch();
    }

    public static Stopwatch createNano() {
        Stopwatch sw = new Stopwatch();
        sw.nano = true;
        return sw;
    }

    public static Stopwatch run(Runnable atom) {
        Stopwatch sw = Stopwatch.begin();
        atom.run();
        sw.stop();
        return sw;
    }

    public static Stopwatch runNano(Runnable atom) {
        Stopwatch sw = Stopwatch.beginNano();
        atom.run();
        sw.stop();
        return sw;
    }

    public long start() {
        this.from = this.currentTime();
        return this.from;
    }

    private long currentTime() {
        return this.nano ? System.nanoTime() : System.currentTimeMillis();
    }

    public long stop() {
        this.to = this.currentTime();
        return this.to;
    }

    public long getDuration() {
        return this.to - this.from;
    }

    public long getStartTime() {
        return this.from;
    }

    public long getEndTime() {
        return this.to;
    }

    public String toString() {
        return String.format("Total: %d%s : [%s]=>[%s]", this.getDuration(), this.nano ? "ns" : "ms", new Timestamp(this.from).toString(), new Timestamp(this.to).toString());
    }
}

