/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang;

import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.LinkedList;
import org.nutz.lang.Lang;
import org.nutz.lang.meta.Email;

public class Strings {
    protected Strings() {
    }

    public static boolean isChineseCharacter(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION;
    }

    public static boolean isFullWidthCharacter(char c) {
        if (c == '\u3000' || c > '\uff00' && c < '\uff5f') {
            return true;
        }
        if (Strings.isChineseCharacter(c)) {
            return true;
        }
        return c >= '\u3040' && c <= '\u30ff';
    }

    public static char toHalfWidthCharacter(char c) {
        if (c == '\u3000') {
            return ' ';
        }
        if (c > '\uff00' && c < '\uff5f') {
            return (char)(c - 65248);
        }
        return c;
    }

    public static String toHalfWidthString(CharSequence str) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            sb.append(Strings.toHalfWidthCharacter(str.charAt(i)));
            ++i;
        }
        return sb.toString();
    }

    public static boolean isFullWidthString(CharSequence str) {
        return Strings.charLength(str) == str.length() * 2;
    }

    public static boolean isHalfWidthString(CharSequence str) {
        return Strings.charLength(str) == str.length();
    }

    public static int charLength(CharSequence str) {
        int clength = 0;
        int i = 0;
        while (i < str.length()) {
            clength += Strings.isFullWidthCharacter(str.charAt(i)) ? 2 : 1;
            ++i;
        }
        return clength;
    }

    public static String dup(CharSequence cs, int num) {
        if (Strings.isEmpty(cs) || num <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(cs.length() * num);
        int i = 0;
        while (i < num) {
            sb.append(cs);
            ++i;
        }
        return sb.toString();
    }

    public static String dup(char c, int num) {
        if (c == '\u0000' || num < 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder(num);
        int i = 0;
        while (i < num) {
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static String capitalize(CharSequence s) {
        return Strings.upperFirst(s);
    }

    public static String lowerFirst(CharSequence s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        if (len == 0) {
            return "";
        }
        char c = s.charAt(0);
        if (Character.isLowerCase(c)) {
            return s.toString();
        }
        return new StringBuilder(len).append(Character.toLowerCase(c)).append(s.subSequence(1, len)).toString();
    }

    public static String upperFirst(CharSequence s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        if (len == 0) {
            return "";
        }
        char c = s.charAt(0);
        if (Character.isUpperCase(c)) {
            return s.toString();
        }
        return new StringBuilder(len).append(Character.toUpperCase(c)).append(s.subSequence(1, len)).toString();
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equalsIgnoreCase(s2);
    }

    public static boolean equals(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    public static boolean startsWithChar(String s, char c) {
        return s != null ? (s.length() == 0 ? false : s.charAt(0) == c) : false;
    }

    public static boolean endsWithChar(String s, char c) {
        return s != null ? (s.length() == 0 ? false : s.charAt(s.length() - 1) == c) : false;
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isBlank(CharSequence cs) {
        if (cs == null) {
            return true;
        }
        int length = cs.length();
        int i = 0;
        while (i < length) {
            if (!Character.isWhitespace(cs.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String trim(CharSequence cs) {
        int last;
        if (cs == null) {
            return null;
        }
        int length = cs.length();
        if (length == 0) {
            return cs.toString();
        }
        int l = 0;
        int r = last = length - 1;
        while (l < length) {
            if (!Character.isWhitespace(cs.charAt(l))) break;
            ++l;
        }
        while (r > l) {
            if (!Character.isWhitespace(cs.charAt(r))) break;
            --r;
        }
        if (l > r) {
            return "";
        }
        if (l == 0 && r == last) {
            return cs.toString();
        }
        return cs.subSequence(l, r + 1).toString();
    }

    public static String brief(String str, int len) {
        if (Strings.isBlank(str) || str.length() + 3 <= len) {
            return str;
        }
        int w = len / 2;
        int l = str.length();
        return String.valueOf(str.substring(0, len - w)) + " ... " + str.substring(l - w);
    }

    public static String[] splitIgnoreBlank(String s) {
        return Strings.splitIgnoreBlank(s, ",");
    }

    public static String[] splitIgnoreBlank(String s, String regex) {
        if (s == null) {
            return null;
        }
        String[] ss = s.split(regex);
        LinkedList<String> list = new LinkedList<String>();
        String[] stringArray = ss;
        int n = ss.length;
        int n2 = 0;
        while (n2 < n) {
            String st = stringArray[n2];
            if (!Strings.isBlank(st)) {
                list.add(Strings.trim(st));
            }
            ++n2;
        }
        return list.toArray(new String[list.size()]);
    }

    public static String fillDigit(int d, int width) {
        return Strings.alignRight(String.valueOf(d), width, '0');
    }

    public static String fillHex(int d, int width) {
        return Strings.alignRight(Integer.toHexString(d), width, '0');
    }

    public static String fillBinary(int d, int width) {
        return Strings.alignRight(Integer.toBinaryString(d), width, '0');
    }

    public static String toDigit(int d, int width) {
        return Strings.cutRight(String.valueOf(d), width, '0');
    }

    public static String toHex(int d, int width) {
        return Strings.cutRight(Integer.toHexString(d), width, '0');
    }

    public static String toBinary(int d, int width) {
        return Strings.cutRight(Integer.toBinaryString(d), width, '0');
    }

    public static String cutRight(String s, int width, char c) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        if (len == width) {
            return s;
        }
        if (len < width) {
            return String.valueOf(Strings.dup(c, width - len)) + s;
        }
        return s.substring(len - width, len);
    }

    public static String cutLeft(String s, int width, char c) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        if (len == width) {
            return s;
        }
        if (len < width) {
            return String.valueOf(s) + Strings.dup(c, width - len);
        }
        return s.substring(0, width);
    }

    public static String alignRight(Object o, int width, char c) {
        if (o == null) {
            return null;
        }
        String s = o.toString();
        int len = s.length();
        if (len >= width) {
            return s;
        }
        return Strings.dup(c, width - len) + s;
    }

    public static String alignLeft(Object o, int width, char c) {
        if (o == null) {
            return null;
        }
        String s = o.toString();
        int length = s.length();
        if (length >= width) {
            return s;
        }
        return s + Strings.dup(c, width - length);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isQuoteByIgnoreBlank(CharSequence cs, char lc, char rc) {
        if (cs == null) {
            return false;
        }
        len = cs.length();
        if (len < 2) {
            return false;
        }
        l = 0;
        r = last = len - 1;
        while (l < len) {
            if (!Character.isWhitespace(cs.charAt(l))) break;
            ++l;
        }
        if (cs.charAt(l) == lc) ** GOTO lbl16
        return false;
        while (Character.isWhitespace(cs.charAt(r))) {
            --r;
lbl16:
            // 2 sources

            if (r > l) continue;
        }
        return l < r && cs.charAt(r) == rc;
    }

    public static boolean isQuoteBy(CharSequence cs, char lc, char rc) {
        if (cs == null) {
            return false;
        }
        int length = cs.length();
        return length > 1 && cs.charAt(0) == lc && cs.charAt(length - 1) == rc;
    }

    public static boolean isQuoteBy(String str, String l, String r) {
        if (str == null || l == null || r == null) {
            return false;
        }
        return str.startsWith(l) && str.endsWith(r);
    }

    public static int maxLength(Collection<? extends CharSequence> coll) {
        int re = 0;
        if (coll != null) {
            for (CharSequence charSequence : coll) {
                if (charSequence == null) continue;
                re = Math.max(re, charSequence.length());
            }
        }
        return re;
    }

    public static <T extends CharSequence> int maxLength(T[] array) {
        int re = 0;
        if (array != null) {
            T[] TArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                T s = TArray[n2];
                if (s != null) {
                    re = Math.max(re, s.length());
                }
                ++n2;
            }
        }
        return re;
    }

    public static String sNull(Object obj) {
        return Strings.sNull(obj, "");
    }

    public static String sNull(Object obj, String def) {
        return obj != null ? obj.toString() : def;
    }

    public static String sBlank(Object obj) {
        return Strings.sBlank(obj, "");
    }

    public static String sBlank(Object obj, String def) {
        if (obj == null) {
            return def;
        }
        String s = obj.toString();
        return Strings.isBlank(s) ? def : s;
    }

    public static String removeFirst(CharSequence str) {
        if (str == null) {
            return null;
        }
        if (str.length() > 1) {
            return str.subSequence(1, str.length()).toString();
        }
        return "";
    }

    public static String removeFirst(String str, char c) {
        return Strings.isEmpty(str) || c != str.charAt(0) ? str : str.substring(1);
    }

    public static boolean isin(String[] ss, String s) {
        if (ss == null || ss.length == 0 || Strings.isBlank(s)) {
            return false;
        }
        String[] stringArray = ss;
        int n = ss.length;
        int n2 = 0;
        while (n2 < n) {
            String w = stringArray[n2];
            if (s.equals(w)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static final boolean isEmail(CharSequence input) {
        if (Strings.isBlank(input)) {
            return false;
        }
        try {
            new Email(input.toString());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String lowerWord(CharSequence cs, char c) {
        StringBuilder sb = new StringBuilder();
        int len = cs.length();
        int i = 0;
        while (i < len) {
            char ch = cs.charAt(i);
            if (Character.isUpperCase(ch)) {
                if (i > 0) {
                    sb.append(c);
                }
                sb.append(Character.toLowerCase(ch));
            } else {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String upperWord(CharSequence cs, char c) {
        StringBuilder sb = new StringBuilder();
        int len = cs.length();
        int i = 0;
        while (i < len) {
            char ch = cs.charAt(i);
            if (ch == c) {
                do {
                    if (++i < len) continue;
                    return sb.toString();
                } while ((ch = cs.charAt(i)) == c);
                sb.append(Character.toUpperCase(ch));
            } else {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String escapeHtml(CharSequence cs) {
        if (cs == null) {
            return null;
        }
        char[] cas = cs.toString().toCharArray();
        StringBuilder sb = new StringBuilder();
        char[] cArray = cas;
        int n = cas.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '\'': {
                    sb.append("&#x27;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++n2;
        }
        return sb.toString();
    }

    public static byte[] getBytesUTF8(CharSequence cs) {
        try {
            return cs.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public static String num2hex(int n) {
        String s = Integer.toHexString(n);
        return n <= 15 ? "0" + s : s;
    }

    public static int hex2num(String hex) {
        return Integer.parseInt(hex, 16);
    }
}

