/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.nutz.lang.Times;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public abstract class Tasks {
    private static Log logger = Logs.get();
    private static ScheduledThreadPoolExecutor taskScheduler = new ScheduledThreadPoolExecutor(Tasks.getBestPoolSize());

    public static ScheduledFuture<?> scheduleAtFixedRate(Runnable task, int periodSeconds) {
        return Tasks.scheduleAtFixedRate(task, 0L, periodSeconds, TimeUnit.SECONDS);
    }

    public static ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long initialDelay, int period, TimeUnit unit) {
        return taskScheduler.scheduleAtFixedRate(task, initialDelay, period, unit);
    }

    public static void scheduleAtFixedRate(Runnable task, String startTime, int period, TimeUnit unit) throws ParseException {
        Date dt = Times.D(startTime);
        Tasks.scheduleAtFixedRate(task, dt, period, unit);
    }

    public static void scheduleAtFixedRate(final Runnable task, Date startTime, final int period, final TimeUnit unit) {
        final Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                taskScheduler.scheduleAtFixedRate(task, 0L, period, unit);
                timer.cancel();
            }
        }, startTime);
    }

    public static ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, int periodSeconds) {
        return Tasks.scheduleWithFixedDelay(task, 0L, periodSeconds, TimeUnit.SECONDS);
    }

    public static ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long initialDelay, int period, TimeUnit unit) {
        return taskScheduler.scheduleWithFixedDelay(task, initialDelay, period, unit);
    }

    public static void scheduleWithFixedDelay(Runnable task, String startTime, int period, TimeUnit unit) throws ParseException {
        Date dt = Times.D(startTime);
        Tasks.scheduleWithFixedDelay(task, dt, period, unit);
    }

    public static void scheduleWithFixedDelay(final Runnable task, Date startTime, final int period, final TimeUnit unit) {
        final Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                taskScheduler.scheduleWithFixedDelay(task, 0L, period, unit);
                timer.cancel();
            }
        }, startTime);
    }

    public static void resizeThreadPool(int threadPoolSize) {
        taskScheduler.setCorePoolSize(threadPoolSize);
    }

    public static ScheduledThreadPoolExecutor getTaskScheduler() {
        return taskScheduler;
    }

    public static void depose() {
        List<Runnable> awaitingExecution = taskScheduler.shutdownNow();
        logger.infof("Tasks stopping. Tasks awaiting execution: %d", awaitingExecution.size());
    }

    public static void reset() {
        Tasks.depose();
        taskScheduler = new ScheduledThreadPoolExecutor(Tasks.getBestPoolSize());
    }

    private static int getBestPoolSize() {
        try {
            int cores = Runtime.getRuntime().availableProcessors();
            return (int)((double)cores / 0.09999999999999998);
        }
        catch (Throwable throwable) {
            return 10;
        }
    }
}

