/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;

public abstract class Times {
    private static Pattern _P_TIME = Pattern.compile("^((\\d{2,4})([/\\\\-])(\\d{1,2})([/\\\\-])(\\d{1,2}))?(([ T])?(\\d{1,2})(:)(\\d{1,2})(:)(\\d{1,2})(([.])(\\d{1,}))?)?(([+-])(\\d{1,2})(:\\d{1,2})?)?$");
    private static final int[] _MDs = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final DateFormat DF_DATE_TIME_MS = new SimpleDateFormat("y-M-d H:m:s.S");
    private static final DateFormat DF_DATE_TIME = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final DateFormat DF_DATE = new SimpleDateFormat("yyyy-MM-dd");
    private static final long MS_DAY = 86400000L;
    private static final long MS_WEEK = 604800000L;

    public static boolean leapYear(int year) {
        if (year < 4) {
            return false;
        }
        return year % 400 == 0 || year % 100 != 0 && year % 4 == 0;
    }

    public static int countLeapYear(int year) {
        int span = year - 1;
        return span / 4 - span / 100 + span / 400;
    }

    public static int[] T(int sec) {
        int[] re;
        re = new int[]{Math.min(23, sec / 3600), Math.min(59, (sec - re[0] * 3600) / 60), Math.min(59, sec - re[0] * 3600 - re[1] * 60)};
        return re;
    }

    public static int T(String ts) {
        String[] tss = Strings.splitIgnoreBlank(ts, ":");
        if (tss != null && tss.length == 3) {
            int hh = Integer.parseInt(tss[0]);
            int mm = Integer.parseInt(tss[1]);
            int ss = Integer.parseInt(tss[2]);
            return hh * 3600 + mm * 60 + ss;
        }
        throw Lang.makeThrow("Wrong format of time string '%s'", ts);
    }

    public static Date now() {
        return new Date(System.currentTimeMillis());
    }

    public static long ams(String ds) {
        return Times.ams(ds, null);
    }

    public static long ams(String ds, TimeZone tz) {
        Matcher m = _P_TIME.matcher(ds);
        if (m.find()) {
            int yy = Times._int(m, 2, 1970);
            int MM = Times._int(m, 4, 1);
            int dd = Times._int(m, 6, 1);
            int HH = Times._int(m, 9, 0);
            int mm = Times._int(m, 11, 0);
            int ss = Times._int(m, 13, 0);
            int ms = Times._int(m, 16, 0);
            long day = Times.D1970(yy, MM, dd);
            long MS = day * 86400000L;
            MS += ((long)HH * 3600L + (long)mm * 60L + (long)ss) * 1000L;
            long tzOffset = tz == null ? (!Strings.isBlank(m.group(17)) ? Long.parseLong(m.group(19)) * 3600000L * (long)(m.group(18).charAt(0) == '-' ? -1 : 1) : (long)TimeZone.getDefault().getRawOffset()) : (long)tz.getRawOffset();
            return (MS += (long)ms) - tzOffset;
        }
        throw Lang.makeThrow("Unexpect date format '%s'", ds);
    }

    public static long ms(String ds, TimeZone tz) {
        return Times.ams(ds, tz);
    }

    public static long ms(Date d) {
        return Times.ms(Times.C(d));
    }

    public static int ms(Calendar c) {
        int ms = c.get(11) * 3600000;
        ms += c.get(12) * 60000;
        ms += c.get(13) * 1000;
        return ms += c.get(14);
    }

    public static int ms() {
        return Times.ms(Calendar.getInstance());
    }

    public static String mss(int ms) {
        int sec = ms / 1000;
        return String.valueOf(Times.secs(sec)) + "." + Strings.alignRight(ms -= sec * 1000, 3, '0');
    }

    public static String secs(int sec) {
        int hh = sec / 3600;
        int mm = (sec -= hh * 3600) / 60;
        return String.valueOf(Strings.alignRight(hh, 2, '0')) + ":" + Strings.alignRight(mm, 2, '0') + ":" + Strings.alignRight(sec -= mm * 60, 2, '0');
    }

    public static int sec(Date d) {
        Calendar c = Times.C(d);
        int sec = c.get(11) * 3600;
        sec += c.get(12) * 60;
        return sec += c.get(13);
    }

    public static int sec() {
        return Times.sec(Times.now());
    }

    public static Date D(String ds) {
        return Times.D(Times.ams(ds));
    }

    private static int _int(Matcher m, int index, int dft) {
        String s = m.group(index);
        if (Strings.isBlank(s)) {
            return dft;
        }
        return Integer.parseInt(s);
    }

    public static int D1970(int yy, int MM, int dd) {
        int year = yy < 100 ? yy + 1970 : yy;
        int day = (year - 1970) * 365;
        day += Times.countLeapYear(year) - Times.countLeapYear(1970);
        int mi = Math.min(MM - 1, 11);
        boolean isLeapYear = Times.leapYear(yy);
        int i = 0;
        while (i < mi) {
            day += _MDs[i];
            ++i;
        }
        if (isLeapYear && MM > 2) {
            ++day;
        }
        day += Math.min(dd, _MDs[mi]) - 1;
        if (isLeapYear && dd == 29) {
            ++day;
        }
        return day;
    }

    public static Date D(long ms) {
        return new Date(ms);
    }

    public static Calendar C(String ds) {
        return Times.C(Times.D(ds));
    }

    public static Calendar C(Date d) {
        return Times.C(d.getTime());
    }

    public static Calendar C(long ms) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(ms);
        return c;
    }

    public static String sDTms(Date d) {
        return Times.format(DF_DATE_TIME_MS, d);
    }

    public static String sDT(Date d) {
        return Times.format(DF_DATE_TIME, d);
    }

    public static String sD(Date d) {
        return Times.format(DF_DATE, d);
    }

    public static String sT(int sec) {
        int[] ss = Times.T(sec);
        return String.valueOf(Strings.alignRight(ss[0], 2, '0')) + ":" + Strings.alignRight(ss[1], 2, '0') + ":" + Strings.alignRight(ss[2], 2, '0');
    }

    public static Date[] week(int off) {
        return Times.week(System.currentTimeMillis(), off);
    }

    public static Date[] week(long base, int off) {
        return Times.weeks(base, off, off);
    }

    public static Date[] weeks(int offL, int offR) {
        return Times.weeks(System.currentTimeMillis(), offL, offR);
    }

    public static Date[] weeks(long base, int offL, int offR) {
        int from = Math.min(offL, offR);
        int len = Math.abs(offL - offR);
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(base);
        Date[] re = new Date[2];
        c.setTimeInMillis(c.getTimeInMillis() + 604800000L * (long)from);
        c.set(7, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        re[0] = c.getTime();
        c.setTimeInMillis(c.getTimeInMillis() + 604800000L * (long)(len + 1) - 1000L);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        re[1] = c.getTime();
        return re;
    }

    public static String format(DateFormat fmt, Date d) {
        return ((DateFormat)fmt.clone()).format(d);
    }

    public static String format(String fmt, Date d) {
        return new SimpleDateFormat(fmt).format(d);
    }

    public static Date parseq(DateFormat fmt, String s) {
        try {
            return Times.parse(fmt, s);
        }
        catch (ParseException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public static Date parseq(String fmt, String s) {
        try {
            return Times.parse(fmt, s);
        }
        catch (ParseException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public static Date parse(DateFormat fmt, String s) throws ParseException {
        return ((DateFormat)fmt.clone()).parse(s);
    }

    public static Date parse(String fmt, String s) throws ParseException {
        return new SimpleDateFormat(fmt).parse(s);
    }
}

