/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.nutz.lang.ContinueLoop;
import org.nutz.lang.Each;
import org.nutz.lang.ExitLoop;
import org.nutz.lang.Lang;
import org.nutz.lang.LoopException;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.lang.util.Callback2;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class Xmls {
    public static DocumentBuilder xmls() throws ParserConfigurationException {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder();
    }

    public static Document xml(InputStream ins) {
        try {
            Document document = Xmls.xmls().parse(ins);
            return document;
        }
        catch (SAXException e) {
            throw Lang.wrapThrow(e);
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
        catch (ParserConfigurationException e) {
            throw Lang.wrapThrow(e);
        }
        finally {
            Streams.safeClose(ins);
        }
    }

    public static Document xml(File xmlFile) {
        try {
            return Xmls.xmls().parse(xmlFile);
        }
        catch (Exception e) {
            throw Lang.wrapThrow(e);
        }
    }

    public static String get(Element ele, String subTagName) {
        Element sub = Xmls.firstChild(ele, subTagName);
        if (sub == null) {
            return null;
        }
        return Xmls.getText(sub);
    }

    public static String getText(Element ele) {
        StringBuilder sb = new StringBuilder();
        Xmls.joinText(ele, sb);
        return Strings.trim(sb);
    }

    public static void joinText(Element ele, StringBuilder sb) {
        if (ele == null) {
            return;
        }
        NodeList nl = ele.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node nd = nl.item(i);
            if (nd.getNodeType() == 3) {
                sb.append(nd.getNodeValue());
            } else if (nd.getNodeType() == 1) {
                Xmls.joinText((Element)nd, sb);
            }
            ++i;
        }
    }

    public static Element firstChild(Element ele) {
        final Element[] tag = new Element[1];
        Xmls.eachChildren(ele, null, new Each<Element>(){

            @Override
            public void invoke(int index, Element cld, int length) {
                tag[0] = cld;
                Lang.Break();
            }
        });
        return tag[0];
    }

    public static Element firstChild(Element ele, String regex) {
        final Element[] tag = new Element[1];
        Xmls.eachChildren(ele, regex, new Each<Element>(){

            @Override
            public void invoke(int index, Element cld, int length) {
                tag[0] = cld;
                Lang.Break();
            }
        });
        return tag[0];
    }

    public static Element lastChild(Element ele) {
        final Element[] tag = new Element[1];
        Xmls.eachChildren(ele, null, new Each<Element>(){

            @Override
            public void invoke(int index, Element cld, int length) {
                tag[0] = cld;
                Lang.Break();
            }
        }, -1);
        return tag[0];
    }

    public static Element lastChild(Element ele, String regex) {
        final Element[] tag = new Element[1];
        Xmls.eachChildren(ele, regex, new Each<Element>(){

            @Override
            public void invoke(int index, Element cld, int length) {
                tag[0] = cld;
                Lang.Break();
            }
        }, -1);
        return tag[0];
    }

    public static List<Element> children(Element ele) {
        return Xmls.children(ele, null);
    }

    public static List<Element> children(Element ele, String regex) {
        final ArrayList<Element> list = new ArrayList<Element>(ele.getChildNodes().getLength());
        Xmls.eachChildren(ele, regex, new Each<Element>(){

            @Override
            public void invoke(int index, Element cld, int length) {
                list.add(cld);
            }
        });
        return list;
    }

    public static void eachChildren(Element ele, Each<Element> callback) {
        Xmls.eachChildren(ele, null, callback);
    }

    public static void eachChildren(Element ele, String regex, Each<Element> callback) {
        Xmls.eachChildren(ele, regex, callback, 0);
    }

    public static boolean hasChild(Element ele, String regex) {
        NodeList nl = ele.getChildNodes();
        int len = nl.getLength();
        int i = 0;
        while (i < len) {
            Node nd = nl.item(i);
            if (nd instanceof Element) {
                if (regex == null) {
                    return false;
                }
                if (((Element)nd).getTagName().matches(regex)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static void eachChildren(Element ele, String regex, final Each<Element> callback, int off) {
        if (ele == null || callback == null) {
            return;
        }
        final Pattern p = regex == null ? null : Pattern.compile(regex);
        NodeList nl = ele.getChildNodes();
        final int len = nl.getLength();
        Callback2<Integer, Node> eachInvoke = new Callback2<Integer, Node>(){

            @Override
            public void invoke(Integer index, Node nd) {
                if (nd instanceof Element) {
                    try {
                        Element tag = (Element)nd;
                        if (p == null || p.matcher(tag.getTagName()).find()) {
                            callback.invoke(index, tag, len);
                        }
                    }
                    catch (ExitLoop e) {
                        throw Lang.wrapThrow(e);
                    }
                    catch (ContinueLoop continueLoop) {
                    }
                    catch (LoopException e) {
                        throw Lang.wrapThrow(e);
                    }
                }
            }
        };
        try {
            if (off < 0) {
                int i = len + off;
                while (i >= 0) {
                    eachInvoke.invoke(i, nl.item(i));
                    --i;
                }
            } else {
                int i = off;
                while (i < len) {
                    eachInvoke.invoke(i, nl.item(i));
                    ++i;
                }
            }
        }
        catch (ExitLoop exitLoop) {
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof ExitLoop) {
                return;
            }
            throw e;
        }
    }

    public static Map<String, String> getAttrs(Element ele) {
        NamedNodeMap nodeMap = ele.getAttributes();
        HashMap<String, String> attrs = new HashMap<String, String>(nodeMap.getLength());
        int i = 0;
        while (i < nodeMap.getLength()) {
            attrs.put(nodeMap.item(i).getNodeName(), nodeMap.item(i).getNodeValue());
            ++i;
        }
        return attrs;
    }

    public static String getAttr(Element ele, String attrName) {
        Node node = ele.getAttributes().getNamedItem(attrName);
        return node != null ? node.getNodeValue() : null;
    }

    public static Map<String, Object> asMap(Element ele) {
        final LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Xmls.eachChildren(ele, new Each<Element>(){

            @Override
            public void invoke(int index, Element _ele, int length) throws ExitLoop, ContinueLoop, LoopException {
                String key = _ele.getNodeName();
                String val = _ele.getAttribute("value");
                if (!Strings.isEmpty(String.valueOf(val))) {
                    map.put(key, val);
                    return;
                }
                if (!_ele.hasChildNodes()) {
                    return;
                }
                NodeList list = _ele.getChildNodes();
                if (list.getLength() == 1 && !(list.item(0) instanceof Element)) {
                    map.put(key, list.item(0).getTextContent().trim().intern());
                    return;
                }
                map.put(key, Xmls.asMap(_ele));
            }
        });
        return map;
    }
}

