/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.born;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.nutz.castor.Castors;
import org.nutz.lang.Lang;
import org.nutz.lang.MatchType;
import org.nutz.lang.Mirror;
import org.nutz.lang.born.BornContext;
import org.nutz.lang.born.ConstructorBorning;
import org.nutz.lang.born.ConstructorCastingBorning;
import org.nutz.lang.born.DynaMethodBorning;
import org.nutz.lang.born.DynamicConstructorBorning;
import org.nutz.lang.born.EmptyArgsConstructorBorning;
import org.nutz.lang.born.EmptyArgsMethodBorning;
import org.nutz.lang.born.MethodBorning;
import org.nutz.lang.born.MethodCastingBorning;

public abstract class Borns {
    public static <T> BornContext<T> evalByArgTypes(Class<T> type, Class<?> ... argTypes) {
        BornContext<T> re = argTypes.length == 0 ? Borns.evalWithoutArgs(type) : Borns.evalWithArgTypes(true, type, argTypes, null);
        return re;
    }

    public static <T> BornContext<T> eval(Class<T> type, Object ... args) {
        BornContext<T> re = args.length == 0 ? Borns.evalWithoutArgs(type) : Borns.evalWithArgs(type, args);
        return re;
    }

    private static <T> BornContext<T> evalWithArgs(Class<T> type, Object[] args) {
        Object dynaArg = Mirror.evalArgToSameTypeRealArray(args);
        Class<?>[] argTypes = Mirror.evalToTypes(args);
        BornContext<T> re = Borns.evalWithArgTypes(false, type, argTypes, dynaArg);
        if (re == null) {
            return null;
        }
        if (MatchType.LACK == re.getMatchType()) {
            re.setArgs(Lang.arrayLast(args, re.getLackArg()));
        } else {
            re.setArgs(args);
        }
        switch (re.getMatchType()) {
            case LACK: {
                re.setArgs(Lang.arrayLast(args, re.getLackArg()));
                break;
            }
            case NEED_CAST: {
                re.setArgs(Lang.array2ObjectArray(args, re.getCastType()));
                break;
            }
            default: {
                re.setArgs(args);
            }
        }
        return re;
    }

    private static <T> BornContext<T> evalWithArgTypes(boolean accurate, Class<T> type, Class<?>[] argTypes, Object dynaArg) {
        Class<?>[] pts;
        BornContext<Object> re = new BornContext<Object>();
        Mirror<Class<T>> mirror = Mirror.me(type);
        Constructor<?>[] constructorArray = type.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> cc = constructorArray[n2];
            Class<?>[] pts2 = cc.getParameterTypes();
            MatchType mt = Mirror.matchParamTypes(pts2, argTypes);
            re.setMatchType(mt);
            if (MatchType.YES == mt) {
                return re.setBorning(new ConstructorBorning(cc));
            }
            if (MatchType.LACK == mt) {
                re.setLackArg(Mirror.blankArrayArg(pts2));
                return re.setBorning(new ConstructorBorning(cc));
            }
            if (dynaArg != null && pts2.length == 1 && pts2[0] == dynaArg.getClass()) {
                return re.setBorning(new DynamicConstructorBorning(cc));
            }
            ++n2;
        }
        Method[] sms = mirror.getStaticMethods();
        Executable[] executableArray = sms;
        int n3 = sms.length;
        n = 0;
        while (n < n3) {
            Method m = executableArray[n];
            pts = m.getParameterTypes();
            MatchType mt = Mirror.matchParamTypes(pts, argTypes);
            re.setMatchType(mt);
            if (MatchType.YES == mt) {
                return re.setBorning(new MethodBorning(m));
            }
            if (MatchType.LACK == mt) {
                re.setLackArg(Mirror.blankArrayArg(pts));
                return re.setBorning(new MethodBorning(m));
            }
            if (dynaArg != null && pts.length == 1 && pts[0] == dynaArg.getClass()) {
                return re.setBorning(new DynaMethodBorning(m));
            }
            ++n;
        }
        if (!accurate) {
            try {
                executableArray = type.getConstructors();
                n3 = executableArray.length;
                n = 0;
                while (n < n3) {
                    Executable cc = executableArray[n];
                    pts = ((Constructor)cc).getParameterTypes();
                    if (Borns.canBeCasted(argTypes, pts)) {
                        re.setMatchType(MatchType.NEED_CAST);
                        re.setCastType(pts);
                        return re.setBorning(new ConstructorCastingBorning(cc));
                    }
                    ++n;
                }
            }
            catch (RuntimeException runtimeException) {}
            try {
                executableArray = sms;
                n3 = sms.length;
                n = 0;
                while (n < n3) {
                    Executable m = executableArray[n];
                    pts = ((Method)m).getParameterTypes();
                    if (Borns.canBeCasted(argTypes, pts)) {
                        re.setMatchType(MatchType.NEED_CAST);
                        re.setCastType(pts);
                        return re.setBorning(new MethodCastingBorning((Method)m));
                    }
                    ++n;
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private static boolean canBeCasted(Class<?>[] argTypes, Class<?>[] pts) {
        if (pts.length != argTypes.length) {
            return false;
        }
        int i = 0;
        while (i < pts.length) {
            if (!Castors.me().canCast(argTypes[i], pts[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static <T> BornContext<T> evalWithoutArgs(Class<T> type) {
        Class<?>[] pts;
        Executable m;
        BornContext re = new BornContext();
        Mirror<Class<T>> mirror = Mirror.me(type);
        boolean isAbstract = Modifier.isAbstract(type.getModifiers());
        try {
            if (!isAbstract) {
                re.setBorning(new EmptyArgsConstructorBorning<T>(type.getConstructor(new Class[0])));
                return re.setArgs(new Object[0]);
            }
        }
        catch (Exception exception) {}
        Method[] stMethods = mirror.getStaticMethods();
        Executable[] executableArray = stMethods;
        int n = stMethods.length;
        int n2 = 0;
        while (n2 < n) {
            m = executableArray[n2];
            if (((Method)m).getReturnType().equals(type) && ((Method)m).getParameterTypes().length == 0) {
                return re.setBorning(new EmptyArgsMethodBorning((Method)m)).setArgs(new Object[0]);
            }
            ++n2;
        }
        if (!isAbstract) {
            executableArray = type.getConstructors();
            n = executableArray.length;
            n2 = 0;
            while (n2 < n) {
                Executable cons = executableArray[n2];
                pts = ((Constructor)cons).getParameterTypes();
                if (pts.length == 1 && pts[0].isArray()) {
                    Object[] args = new Object[]{Mirror.blankArrayArg(pts)};
                    return re.setBorning(new ConstructorBorning(cons)).setArgs(args);
                }
                ++n2;
            }
        }
        executableArray = stMethods;
        n = stMethods.length;
        n2 = 0;
        while (n2 < n) {
            m = executableArray[n2];
            pts = ((Method)m).getParameterTypes();
            if (((Method)m).getReturnType() == type && ((Method)m).getParameterTypes().length == 1 && pts[0].isArray()) {
                Object[] args = new Object[]{Mirror.blankArrayArg(pts)};
                return re.setBorning(new MethodBorning((Method)m)).setArgs(args);
            }
            ++n2;
        }
        return null;
    }
}

