/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.eject;

import java.lang.reflect.Field;
import org.nutz.lang.Lang;
import org.nutz.lang.eject.Ejecting;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class EjectByField
implements Ejecting {
    private static final Log log = Logs.get();
    private Field field;

    public EjectByField(Field field) {
        this.field = field;
        this.field.setAccessible(true);
    }

    @Override
    public Object eject(Object obj) {
        try {
            return obj == null ? null : this.field.get(obj);
        }
        catch (Exception e) {
            if (log.isInfoEnabled()) {
                log.info("Fail to get value by field", e);
            }
            throw Lang.makeThrow("Fail to get field %s.'%s' because [%s]: %s", this.field.getDeclaringClass().getName(), this.field.getName(), Lang.unwrapThrow(e), Lang.unwrapThrow(e).getMessage());
        }
    }
}

