/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.eject;

import java.lang.reflect.Method;
import org.nutz.lang.Lang;
import org.nutz.lang.eject.Ejecting;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class EjectByGetter
implements Ejecting {
    private static final Log log = Logs.get();
    private Method getter;

    public EjectByGetter(Method getter) {
        this.getter = getter;
    }

    @Override
    public Object eject(Object obj) {
        try {
            return obj == null ? null : this.getter.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            if (log.isInfoEnabled()) {
                log.info("Fail to value by getter", e);
            }
            throw Lang.makeThrow("Fail to invoke getter %s.'%s()' because [%s]: %s", this.getter.getDeclaringClass().getName(), this.getter.getName(), Lang.unwrapThrow(e), Lang.unwrapThrow(e).getMessage());
        }
    }
}

