/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.meta;

import org.nutz.lang.Lang;
import org.nutz.lang.Strings;

public class Pair<T> {
    private static final String PTN_1 = "%s=%s";
    private static final String PTN_2 = "%s='%s'";
    private static final String PTN_3 = "%s=\"%s\"";
    private String name;
    private T value;
    private String pattern;

    public static Pair<String> create(String s) {
        String[] ss = Strings.splitIgnoreBlank(s, "=");
        String name = null;
        String value = null;
        String pattern = PTN_3;
        if (ss != null) {
            if (ss.length == 1) {
                name = ss[0];
            } else if (ss.length == 2) {
                name = ss[0];
                if (ss[1].length() > 0) {
                    if (ss[1].charAt(0) == '\"') {
                        value = ss[1].substring(1, ss[1].length() - 1);
                        pattern = PTN_3;
                    } else if (ss[1].charAt(0) == '\'') {
                        value = ss[1].substring(1, ss[1].length() - 1);
                        pattern = PTN_2;
                    } else {
                        value = ss[1];
                        pattern = PTN_1;
                    }
                }
            }
        }
        Pair<Object> re = new Pair<Object>(name, value);
        re.pattern = pattern;
        return re;
    }

    public Pair() {
    }

    public Pair(String name, T value) {
        this.name = name;
        this.value = value;
        this.pattern = PTN_3;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public T getValue() {
        return this.value;
    }

    public String getValueString() {
        return this.value == null ? null : this.value.toString();
    }

    public void setValue(T value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Pair && Strings.equals(((Pair)obj).name, this.name)) {
            return Lang.equals(((Pair)obj).value, this.value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        String v = this.value == null ? "" : this.value.toString();
        v = v.replace("\"", "&quot;");
        return String.format(this.pattern, this.name, v);
    }
}

