/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.socket;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.nutz.lang.socket.SocketAction;

public class SocketActionTable {
    private boolean[] nots;
    private SocketAction[] aary;
    private Pattern[] ptns;
    private Map<String, SocketAction> map;

    SocketActionTable(Map<String, SocketAction> actions) {
        ArrayList<String> rl = new ArrayList<String>(actions.size());
        ArrayList<SocketAction> al = new ArrayList<SocketAction>(actions.size());
        this.map = new HashMap<String, SocketAction>();
        for (String key : actions.keySet()) {
            if (key == null) {
                rl.add("$:.*");
                al.add(actions.get(key));
                continue;
            }
            if (key.startsWith("$:")) {
                rl.add(key.substring(2));
                al.add(actions.get(key));
                continue;
            }
            this.map.put(key, actions.get(key));
        }
        this.nots = new boolean[rl.size()];
        Arrays.fill(this.nots, false);
        this.aary = new SocketAction[this.nots.length];
        this.ptns = new Pattern[this.nots.length];
        int i = 0;
        while (i < this.nots.length) {
            this.aary[i] = (SocketAction)al.get(i);
            if (((String)rl.get(i)).startsWith("!")) {
                this.nots[i] = true;
                this.ptns[i] = Pattern.compile(((String)rl.get(i)).substring(1));
            } else {
                this.ptns[i] = Pattern.compile((String)rl.get(i));
            }
            ++i;
        }
    }

    public SocketAction get(String line) {
        SocketAction sa = this.map.get(line);
        if (sa != null) {
            return sa;
        }
        int i = 0;
        while (i < this.nots.length) {
            if (this.ptns[i].matcher(line).find() && !this.nots[i]) {
                return this.aary[i];
            }
            if (this.nots[i]) {
                return this.aary[i];
            }
            ++i;
        }
        return null;
    }
}

