/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.socket;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import org.nutz.lang.Lang;
import org.nutz.lang.socket.SocketAtom;
import org.nutz.lang.util.SimpleContext;

public class SocketContext
extends SimpleContext {
    private SocketAtom atom;

    public SocketContext(SocketAtom atom) {
        this.atom = atom;
    }

    public BufferedReader getReader() {
        return this.atom.br;
    }

    public String readLine() throws IOException {
        if (this.atom.socket.isClosed()) {
            return null;
        }
        return this.atom.br.readLine();
    }

    public String getCurrentLine() {
        return this.atom.line;
    }

    public OutputStream getOutputStream() {
        return this.atom.ops;
    }

    public void write(String str) {
        if (!this.atom.socket.isClosed()) {
            try {
                this.atom.ops.write(str.getBytes("UTF-8"));
            }
            catch (IOException e) {
                throw Lang.wrapThrow(e);
            }
        }
    }

    public void writeLine(String str) {
        this.write(String.valueOf(str) + "\n");
    }
}

