/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Streams;
import org.nutz.lang.socket.CloseSocketException;
import org.nutz.lang.socket.SocketAction;
import org.nutz.lang.socket.SocketActionTable;
import org.nutz.lang.socket.SocketAtom;
import org.nutz.lang.socket.SocketContext;
import org.nutz.lang.util.Context;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public abstract class Sockets {
    private static final Log log = Logs.get();
    private static final int DEFAULT_POOL_SIZE = 10;

    public static void send(String host, int port, InputStream ins, OutputStream ops) {
        Socket socket = null;
        try {
            try {
                socket = new Socket(InetAddress.getByName(host), port);
                OutputStream sOut = socket.getOutputStream();
                Streams.write(sOut, ins);
                sOut.flush();
                if (!socket.isClosed()) {
                    InputStream sReturn = socket.getInputStream();
                    Streams.write(ops, sReturn);
                }
            }
            catch (IOException e) {
                throw Lang.wrapThrow(e);
            }
        }
        finally {
            Streams.safeClose(ins);
            Streams.safeClose(ops);
            Sockets.safeClose(socket);
        }
    }

    public static String sendText(String host, int port, String text) {
        StringBuilder sb = new StringBuilder();
        Sockets.send(host, port, Lang.ins(text), Lang.ops(sb));
        return sb.toString();
    }

    public static void localListenOneAndStop(int port, String line, SocketAction action) {
        Map<String, SocketAction> actions = Sockets.createActions();
        actions.put(line, action);
        actions.put("$:^(close|stop|bye|exit)$", Sockets.doClose());
        Sockets.localListenByLine(port, actions);
    }

    public static void localListenOne(int port, String line, SocketAction action) {
        Map<String, SocketAction> actions = Sockets.createActions();
        actions.put(line, action);
        Sockets.localListenByLine(port, actions);
    }

    public static void localListenByLine(int port, Map<String, SocketAction> actions) {
        Sockets.localListenByLine(port, actions, 10);
    }

    public static void localListenByLine(int port, Map<String, SocketAction> actions, int poolSize) {
        Sockets.localListenByLine(port, actions, Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * poolSize));
    }

    public static void localListenByLine(int port, Map<String, SocketAction> actions, ExecutorService service) {
        Sockets.localListen(port, actions, service, SocketAtom.class);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void localListen(int port, Map<String, SocketAction> actions, ExecutorService service, Class<? extends SocketAtom> klass) {
        try {
            saTable = new SocketActionTable(actions);
            try {
                server = new ServerSocket(port);
            }
            catch (IOException e1) {
                throw Lang.wrapThrow(e1);
            }
            if (Sockets.log.isInfoEnabled()) {
                Sockets.log.infof("Local socket is up at :%d with %d action ready", new Object[]{port, actions.size()});
            }
            context = Lang.context();
            context.set("stop", false);
            new Thread(){

                @Override
                public void run() {
                    this.setName("Nutz.Sockets monitor thread");
                    while (true) {
                        try {
                            do {
                                Thread.sleep(1000L);
                            } while (!context.getBoolean("stop"));
                            try {
                                server.close();
                            }
                            catch (Throwable throwable) {}
                            return;
                        }
                        catch (Throwable throwable) {
                            continue;
                        }
                        break;
                    }
                }
            }.start();
            borning = Mirror.me(klass).getBorningByArgTypes(new Class[]{Context.class, Socket.class, SocketActionTable.class});
            if (borning != null) ** GOTO lbl43
            Sockets.log.error("boring == null !!!!");
        }
        catch (Throwable var10_13) {
            if (Sockets.log.isInfoEnabled()) {
                Sockets.log.info("Stop services ...");
            }
            service.shutdown();
            throw var10_13;
        }
        if (Sockets.log.isInfoEnabled()) {
            Sockets.log.info("Stop services ...");
        }
        service.shutdown();
        return;
        {
            catch (RuntimeException e) {
                throw e;
            }
        }
lbl-1000:
        // 1 sources

        {
            try {
                if (Sockets.log.isDebugEnabled()) {
                    Sockets.log.debug("Waiting for new socket");
                }
                socket = server.accept();
                if (context.getBoolean("stop")) {
                    Sockets.safeClose(socket);
                    break;
                }
                if (Sockets.log.isDebugEnabled()) {
                    Sockets.log.debug("accept a new socket, create new SocketAtom to handle it ...");
                }
                runnable = (Runnable)borning.born(new Object[]{context, socket, saTable});
                service.execute(runnable);
                continue;
            }
            catch (Throwable e) {
                Sockets.log.info("Throwable catched!! maybe ask to exit", e);
            }
lbl43:
            // 3 sources

            ** while (!context.getBoolean((String)"stop"))
        }
lbl44:
        // 2 sources

        if (!server.isClosed()) {
            try {
                server.close();
            }
            catch (Throwable v0) {}
        }
        Sockets.log.info("Seem stop signal was got, wait 15 for all running thread");
        try {
            service.shutdown();
            service.awaitTermination(15L, TimeUnit.SECONDS);
        }
        catch (InterruptedException v1) {}
        try {
            service.shutdownNow();
        }
        catch (Throwable v2) {}
        if (Sockets.log.isInfoEnabled()) {
            Sockets.log.info("Stop services ...");
        }
        service.shutdown();
        if (Sockets.log.isInfoEnabled()) {
            Sockets.log.infof("Local socket is down for :%d", new Object[]{port});
        }
    }

    public static Socket safeClose(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
                socket = null;
            }
            catch (IOException e) {
                throw Lang.wrapThrow(e);
            }
        }
        return null;
    }

    public static SocketAction doClose() {
        return new SocketAction(){

            @Override
            public void run(SocketContext context) {
                throw new CloseSocketException();
            }
        };
    }

    public static void close() {
        throw new CloseSocketException();
    }

    public static Map<String, SocketAction> createActions() {
        HashMap<String, SocketAction> actions = new HashMap<String, SocketAction>();
        return actions;
    }
}

