/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.nutz.lang.Encoding;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;
import org.nutz.lang.stream.StringOutputStream;

public class StreamBuffer
extends InputStream {
    private OutputStreamBuffer buffer = new OutputStreamBuffer();
    private int index = 0;
    private int cursor = 0;

    public OutputStream getBuffer() {
        return this.buffer;
    }

    public void write(int b) throws IOException {
        this.buffer.write(b);
    }

    @Override
    public int read() throws IOException {
        if (this.cursor > this.buffer.width) {
            ++this.index;
            this.cursor = 0;
        }
        if (this.index > this.buffer.index) {
            return -1;
        }
        if (this.index < this.buffer.bytes.size()) {
            byte[] cs = (byte[])this.buffer.bytes.get(this.index);
            if (this.cursor < this.buffer.cursor) {
                return cs[this.cursor++];
            }
        }
        return -1;
    }

    @Override
    public int available() throws IOException {
        return this.buffer.size();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.index = 0;
        this.cursor = 0;
    }

    public String toString() {
        try {
            return this.toString(Encoding.defaultEncoding());
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public String toString(String charset) throws IOException {
        byte c;
        this.index = 0;
        this.cursor = 0;
        StringBuilder sb = new StringBuilder();
        StringOutputStream sos = new StringOutputStream(sb, charset);
        while ((c = (byte)this.read()) != -1) {
            sos.write(c);
        }
        Streams.safeFlush(sos);
        Streams.safeClose(sos);
        return sb.toString();
    }

    private static class OutputStreamBuffer
    extends OutputStream {
        private ArrayList<byte[]> bytes = new ArrayList();
        private int width = 1024;
        private int index = 0;
        private int cursor = 0;

        private OutputStreamBuffer() {
        }

        @Override
        public void write(int b) throws IOException {
            byte[] row;
            if (this.cursor >= this.width) {
                ++this.index;
            }
            byte[] byArray = row = this.bytes.size() > this.index ? this.bytes.get(this.index) : null;
            if (row == null) {
                row = new byte[this.width];
                this.bytes.add(row);
                this.cursor = 0;
            }
            row[this.cursor++] = (byte)b;
        }

        private int size() {
            return this.index > 0 ? this.width * (this.index - 1) + this.cursor : this.cursor;
        }
    }
}

