/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.util;

import java.io.File;
import java.io.FileFilter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.LinkedList;
import org.nutz.lang.Encoding;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.util.ClassTools;
import org.nutz.lang.util.FileVisitor;

public abstract class Disks {
    public static int visitFile(File f, FileVisitor fv, FileFilter filter) {
        int re = 0;
        if (f.isFile()) {
            fv.visit(f);
            ++re;
        } else if (f.isDirectory()) {
            File[] fs;
            File[] fileArray = fs = filter == null ? f.listFiles() : f.listFiles(filter);
            if (fs != null) {
                File[] fileArray2 = fs;
                int n = fs.length;
                int n2 = 0;
                while (n2 < n) {
                    File theFile = fileArray2[n2];
                    re += Disks.visitFile(theFile, fv, filter);
                    ++n2;
                }
            }
        }
        return re;
    }

    public static String getRelativePath(File base, File file) {
        String pathBase = base.getAbsolutePath();
        if (base.isDirectory()) {
            pathBase = String.valueOf(pathBase) + "/";
        }
        String pathFile = file.getAbsolutePath();
        if (file.isDirectory()) {
            pathFile = String.valueOf(pathFile) + "/";
        }
        return Disks.getRelativePath(pathBase, pathFile);
    }

    public static String getRelativePath(String base, String path) {
        String[] bb = Strings.splitIgnoreBlank(Disks.getCanonicalPath(base), "[\\\\/]");
        String[] ff = Strings.splitIgnoreBlank(Disks.getCanonicalPath(path), "[\\\\/]");
        int len = Math.min(bb.length, ff.length);
        int pos = 0;
        while (pos < len) {
            if (!bb[pos].equals(ff[pos])) break;
            ++pos;
        }
        if (len == pos && bb.length == ff.length) {
            return "./";
        }
        int dir = 1;
        if (base.endsWith("/")) {
            dir = 0;
        }
        StringBuilder sb = new StringBuilder(Strings.dup("../", bb.length - pos - dir));
        return sb.append((CharSequence)Lang.concat(pos, ff.length - pos, Character.valueOf('/'), ff)).toString();
    }

    public static String getCanonicalPath(String path) {
        if (Strings.isBlank(path)) {
            return path;
        }
        String[] pa = Strings.splitIgnoreBlank(path, "[\\\\/]");
        LinkedList<String> paths = new LinkedList<String>();
        String[] stringArray = pa;
        int n = pa.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if ("..".equals(s)) {
                if (paths.size() > 0) {
                    paths.removeLast();
                }
            } else {
                paths.add(s);
            }
            ++n2;
        }
        if (path.charAt(0) == '/') {
            return Lang.concat((Object)"/", paths).insert(0, '/').toString();
        }
        return Lang.concat((Object)"/", paths).toString();
    }

    public static String home() {
        return System.getProperty("user.home");
    }

    public static String home(String path) {
        return String.valueOf(Disks.home()) + path;
    }

    public static String absolute(String path) {
        return Disks.absolute(path, ClassTools.getClassLoader(), Encoding.defaultEncoding());
    }

    public static String absolute(String path, ClassLoader klassLoader, String enc) {
        if (Strings.isEmpty(path = Disks.normalize(path, enc))) {
            return null;
        }
        File f = new File(path);
        if (!f.exists()) {
            URL url = null;
            try {
                url = klassLoader.getResource(path);
                if (url == null) {
                    url = Thread.currentThread().getContextClassLoader().getResource(path);
                }
                if (url == null) {
                    url = ClassLoader.getSystemResource(path);
                }
            }
            catch (Throwable throwable) {}
            if (url != null) {
                return Disks.normalize(url.getPath(), "UTF-8");
            }
            return null;
        }
        return path;
    }

    public static String normalize(String path) {
        return Disks.normalize(path, Encoding.defaultEncoding());
    }

    public static String normalize(String path, String enc) {
        if (Strings.isEmpty(path)) {
            return null;
        }
        if (path.charAt(0) == '~') {
            path = String.valueOf(Disks.home()) + path.substring(1);
        }
        try {
            return URLDecoder.decode(path, enc);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static final void visitFile(String path, final String suffix, final boolean deep, final FileVisitor fv) {
        File d = Files.findFile(path);
        if (d == null) {
            return;
        }
        Disks.visitFile(d, new FileVisitor(){

            @Override
            public void visit(File f) {
                if (f.isDirectory()) {
                    return;
                }
                fv.visit(f);
            }
        }, new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return deep;
                }
                return !f.getName().startsWith(".") && f.getName().endsWith(suffix);
            }
        });
    }
}

