/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.nutz.lang.meta.Pair;

public class HtmlToken {
    private static final Pattern BLOCK = Pattern.compile("^(head|div|p|ul|ol|blockquote|pre|title|h[1-9]|li|hr|table|tr|td)$", 2);
    private static final Pattern INLINE = Pattern.compile("^(span|b|i|u|em|strong|sub|sup|code|font)$", 2);
    private static final Pattern NOCHILD = Pattern.compile("^(br|img|link|hr|meta)$", 2);
    private String name;
    private String value;
    private List<Pair<String>> attributes = new ArrayList<Pair<String>>();

    HtmlToken() {
    }

    public String getName() {
        return this.name;
    }

    public HtmlToken setName(String name) {
        this.name = name;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public HtmlToken setValue(String value) {
        this.value = value;
        return this;
    }

    public boolean isElement() {
        return this.name != null;
    }

    public boolean isText() {
        return this.name == null && this.value != null;
    }

    public boolean isBlock() {
        if (this.name == null) {
            return false;
        }
        return BLOCK.matcher(this.name).find();
    }

    public boolean isInline() {
        if (this.name == null) {
            return false;
        }
        return INLINE.matcher(this.name).find();
    }

    public boolean isNoChild() {
        if (this.name == null) {
            return true;
        }
        return NOCHILD.matcher(this.name).find();
    }

    public boolean isHtml() {
        if (this.name == null) {
            return false;
        }
        return this.name.equalsIgnoreCase("html");
    }

    public boolean isBody() {
        if (this.name == null) {
            return false;
        }
        return this.name.equalsIgnoreCase("body");
    }

    public HtmlToken attr(String name, String value) {
        Pair<String> attr = this.getAttr(name);
        if (attr == null) {
            attr = new Pair<String>(name, value);
            this.attributes.add(attr);
        } else {
            attr.setValue(value);
        }
        return this;
    }

    public HtmlToken attr(String name, int value) {
        return this.attr(name, String.valueOf(value));
    }

    public Pair<String> getAttr(String name) {
        for (Pair<String> attr : this.attributes) {
            if (!attr.getName().equals(name)) continue;
            return attr;
        }
        return null;
    }

    public String getAttrVal(String name) {
        Pair<String> p = this.getAttr(name);
        return p == null ? null : p.getValueString();
    }

    public List<Pair<String>> getAttributes() {
        return this.attributes;
    }
}

