/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.util;

import org.nutz.lang.Strings;

public class IntRange {
    private int left;
    private int right;

    public static IntRange make(String s) {
        char[] cs = Strings.trim(s).toCharArray();
        int i = 0;
        while (i < cs.length) {
            char c = cs[i];
            if (c == ',' || c == ':') break;
            ++i;
        }
        if (i == cs.length) {
            return IntRange.make(Integer.parseInt(new String(cs)));
        }
        int left = Integer.parseInt(String.valueOf(cs, 0, i));
        return IntRange.make(left, Integer.parseInt(String.valueOf(cs, ++i, cs.length - i)));
    }

    public static IntRange make(int right) {
        return IntRange.make(0, right);
    }

    public static IntRange make(int left, int right) {
        return new IntRange(left, right);
    }

    private IntRange(int left, int right) {
        this.left = left;
        this.right = right;
    }

    public boolean in(int n) {
        return n > this.left && n < this.right;
    }

    public boolean on(int n) {
        return n == this.left || n == this.right;
    }

    public boolean inon(int n) {
        return this.on(n) || this.in(n);
    }

    public boolean gt(int n) {
        return n < this.left;
    }

    public boolean lt(int n) {
        return n > this.right;
    }

    public boolean linon(int n) {
        return n >= this.left && n < this.right;
    }

    public boolean rinon(int n) {
        return n > this.left && n <= this.right;
    }

    public int getLeft() {
        return this.left;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public int getRight() {
        return this.right;
    }

    public void setRight(int right) {
        this.right = right;
    }

    public String toString() {
        return String.format("%d:%d", this.left, this.right);
    }
}

