/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.nutz.json.Json;
import org.nutz.lang.Lang;

public class LinkedArray<T> {
    private Class<T> eleType;
    private int offset;
    private int cursor;
    private int width;
    private ArrayList<T[]> cache;

    public LinkedArray() {
        this(256);
    }

    public LinkedArray(int size) {
        this(null, size);
    }

    public LinkedArray(Class<T> eleType, int size) {
        this.eleType = eleType;
        if (size <= 0) {
            Lang.makeThrow("width must >0!", new Object[0]);
        }
        this.width = size;
        this.cache = new ArrayList();
    }

    public LinkedArray<T> push(T e) {
        Object[] array;
        int row = this.cursor / this.width;
        int i = this.cursor % this.width;
        if (this.cache.size() == 0 || this.cursor != this.offset && i == 0) {
            array = this.eleType == null ? (Object[])Array.newInstance(e.getClass(), this.width) : (Object[])Array.newInstance(this.eleType, this.width);
            this.cache.add(array);
        } else {
            array = this.cache.get(row);
        }
        array[i] = e;
        ++this.cursor;
        return this;
    }

    public LinkedArray<T> pushAll(T ... es) {
        T[] TArray = es;
        int n = es.length;
        int n2 = 0;
        while (n2 < n) {
            T e = TArray[n2];
            this.push(e);
            ++n2;
        }
        return this;
    }

    public T popFirst() {
        return this.innerGet(this.offset++);
    }

    public String popFirst(int num) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < num) {
            sb.append(this.popFirst());
            ++i;
        }
        return sb.toString();
    }

    public T popLast() {
        return this.innerGet(--this.cursor);
    }

    public LinkedArray<T> popLast(int num) {
        int i = 0;
        while (i < num) {
            this.popLast();
            ++i;
        }
        return this;
    }

    public T first() {
        if (this.size() == 0) {
            return null;
        }
        return this.innerGet(this.offset);
    }

    public T last() {
        if (this.size() == 0) {
            return null;
        }
        return this.innerGet(this.cursor - 1);
    }

    public LinkedArray<T> set(int index, T e) {
        this.checkBound(index);
        T[] array = this.cache.get((index += this.offset) / this.width);
        array[index % this.width] = e;
        return this;
    }

    private void checkBound(int index) {
        if (index >= this.size() || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
    }

    public LinkedArray<T> clear() {
        this.cache.clear();
        this.cursor = 0;
        this.offset = 0;
        return this;
    }

    private T innerGet(int index) {
        T[] array = this.cache.get(index / this.width);
        return array[index % this.width];
    }

    public T get(int index) {
        this.checkBound(index);
        return this.innerGet(index + this.offset);
    }

    public boolean isEmpty() {
        return this.cursor - this.offset == 0;
    }

    public int size() {
        return this.cursor - this.offset;
    }

    public T[] toArray() {
        if (this.size() == 0) {
            if (this.eleType == null) {
                return new Object[0];
            }
            return (Object[])Array.newInstance(this.eleType, 0);
        }
        Object[] re = this.eleType == null ? (Object[])Array.newInstance(this.first().getClass(), this.size()) : (Object[])Array.newInstance(this.eleType, this.size());
        int i = 0;
        while (i < re.length) {
            re[i] = this.innerGet(i);
            ++i;
        }
        return re;
    }

    public List<T> toList() {
        int len = this.size();
        ArrayList<T> list = new ArrayList<T>(len);
        int i = 0;
        while (i < len) {
            list.add(this.innerGet(i));
            ++i;
        }
        return list;
    }

    public Iterator<T> iterator() {
        return new LinkedArrayIterator(this);
    }

    public String toString() {
        return Json.toJson(this.toArray());
    }

    public String popAll() {
        String re = this.toString();
        this.clear();
        return re;
    }

    public boolean contains(T obj) {
        int i = 0;
        while (i < this.size()) {
            if (this.innerGet(i).equals(obj)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int indexOf(T obj) {
        int i = 0;
        while (i < this.size()) {
            if (this.innerGet(i).equals(obj)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(T obj) {
        int i = this.size() - 1;
        while (i >= 0) {
            if (this.innerGet(i).equals(obj)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    class LinkedArrayIterator<E>
    implements Iterator<E> {
        LinkedArray<E> stack;
        int i;

        LinkedArrayIterator(LinkedArray<E> stack) {
            this.stack = stack;
            this.i = ((LinkedArray)stack).offset;
        }

        @Override
        public boolean hasNext() {
            return this.i < ((LinkedArray)this.stack).cursor;
        }

        @Override
        public E next() {
            if (this.i >= ((LinkedArray)this.stack).offset && this.i < ((LinkedArray)this.stack).cursor) {
                return (E)((LinkedArray)this.stack).innerGet(this.i++);
            }
            return null;
        }

        @Override
        public void remove() {
            throw Lang.noImplement();
        }
    }
}

