/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.util;

import java.util.ArrayList;
import org.nutz.json.Json;
import org.nutz.lang.Lang;

public class LinkedLongArray {
    private int offset;
    private int cursor;
    private int width;
    private ArrayList<long[]> cache;

    public LinkedLongArray() {
        this(256);
    }

    public LinkedLongArray(int size) {
        if (size < 0) {
            Lang.makeThrow("width must >0!", new Object[0]);
        }
        this.width = size;
        this.cache = new ArrayList();
    }

    public LinkedLongArray push(long e) {
        long[] array;
        int row = this.cursor / this.width;
        int i = this.cursor % this.width;
        if (this.cache.size() == 0 || this.cursor != this.offset && i == 0) {
            array = new long[this.width];
            this.cache.add(array);
        } else {
            array = this.cache.get(row);
        }
        array[i] = e;
        ++this.cursor;
        return this;
    }

    public long popFirst() {
        return this.innerGet(this.offset++);
    }

    public long popLast() {
        return this.innerGet(--this.cursor);
    }

    public LinkedLongArray popLast(long num) {
        long i = 0L;
        while (i < num) {
            this.popLast();
            ++i;
        }
        return this;
    }

    public long first() {
        if (this.size() == 0) {
            return -1L;
        }
        return this.innerGet(this.offset);
    }

    public long last() {
        if (this.size() == 0) {
            return -1L;
        }
        return this.innerGet(this.cursor - 1);
    }

    public LinkedLongArray set(int index, long e) {
        this.checkBound(index);
        long[] array = this.cache.get((index += this.offset) / this.width);
        array[index % this.width] = e;
        return this;
    }

    private void checkBound(long index) {
        if (index >= (long)this.size() || index < 0L) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
    }

    public LinkedLongArray clear() {
        this.cache.clear();
        this.cursor = 0;
        this.offset = 0;
        return this;
    }

    private long innerGet(int index) {
        long[] array = this.cache.get(index / this.width);
        return array[index % this.width];
    }

    public long get(int index) {
        this.checkBound(index);
        return this.innerGet(index + this.offset);
    }

    public boolean isEmpty() {
        return this.cursor - this.offset == 0;
    }

    public int size() {
        return this.cursor - this.offset;
    }

    public long[] toArray() {
        long[] re = new long[this.size()];
        int i = 0;
        while (i < re.length) {
            re[i] = this.get(i);
            ++i;
        }
        return re;
    }

    public String toString() {
        return Lang.concat((Object)Character.valueOf(','), this.toArray()).toString();
    }

    public String toJson() {
        return Json.toJson(this.toArray());
    }
}

