/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MethodParamNamesScaner {
    public static List<String> getParamNames(Method method) {
        List<String> list;
        int size;
        block6: {
            try {
                size = method.getParameterTypes().length;
                if (size == 0) {
                    return new ArrayList<String>(0);
                }
                list = MethodParamNamesScaner.getParamNames(method.getDeclaringClass()).get(MethodParamNamesScaner.getKey(method));
                if (list != null) break block6;
                return null;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        if (list.size() == size) {
            return list;
        }
        if (list.size() > size) {
            return list.subList(0, size);
        }
        return null;
    }

    public static List<String> getParamNames(Constructor<?> constructor) {
        try {
            int size = constructor.getParameterTypes().length;
            if (size == 0) {
                return new ArrayList<String>(0);
            }
            List<String> list = MethodParamNamesScaner.getParamNames(constructor.getDeclaringClass()).get(MethodParamNamesScaner.getKey(constructor));
            if (list != null && list.size() != size) {
                return list.subList(0, size);
            }
            return list;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, List<String>> getParamNames(Class<?> klass) throws IOException {
        InputStream in = klass.getResourceAsStream("/" + klass.getName().replace('.', '/') + ".class");
        return MethodParamNamesScaner.getParamNames(in);
    }

    public static Map<String, List<String>> getParamNames(InputStream in) throws IOException {
        DataInputStream dis = new DataInputStream(new BufferedInputStream(in));
        HashMap<String, List<String>> names = new HashMap<String, List<String>>();
        HashMap<Integer, String> strs = new HashMap<Integer, String>();
        dis.skipBytes(4);
        dis.skipBytes(2);
        dis.skipBytes(2);
        int constant_pool_count = dis.readUnsignedShort();
        int i = 0;
        while (i < constant_pool_count - 1) {
            byte flag = dis.readByte();
            switch (flag) {
                case 7: {
                    dis.skipBytes(2);
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    dis.skipBytes(2);
                    dis.skipBytes(2);
                    break;
                }
                case 8: {
                    dis.skipBytes(2);
                    break;
                }
                case 3: 
                case 4: {
                    dis.skipBytes(4);
                    break;
                }
                case 5: 
                case 6: {
                    dis.skipBytes(8);
                    ++i;
                    break;
                }
                case 12: {
                    dis.skipBytes(2);
                    dis.skipBytes(2);
                    break;
                }
                case 1: {
                    int len = dis.readUnsignedShort();
                    byte[] data = new byte[len];
                    dis.readFully(data);
                    strs.put(i + 1, new String(data, "UTF-8"));
                    break;
                }
                case 15: {
                    dis.skipBytes(1);
                    dis.skipBytes(2);
                    break;
                }
                case 16: {
                    dis.skipBytes(2);
                    break;
                }
                case 18: {
                    dis.skipBytes(2);
                    dis.skipBytes(2);
                    break;
                }
                default: {
                    throw new RuntimeException("Impossible!! flag=" + flag);
                }
            }
            ++i;
        }
        dis.skipBytes(2);
        dis.skipBytes(2);
        dis.skipBytes(2);
        int interfaces_count = dis.readUnsignedShort();
        dis.skipBytes(2 * interfaces_count);
        int fields_count = dis.readUnsignedShort();
        int i2 = 0;
        while (i2 < fields_count) {
            dis.skipBytes(2);
            dis.skipBytes(2);
            dis.skipBytes(2);
            int attributes_count = dis.readUnsignedShort();
            int j = 0;
            while (j < attributes_count) {
                dis.skipBytes(2);
                int attribute_length = dis.readInt();
                dis.skipBytes(attribute_length);
                ++j;
            }
            ++i2;
        }
        int methods_count = dis.readUnsignedShort();
        int i3 = 0;
        while (i3 < methods_count) {
            dis.skipBytes(2);
            String methodName = (String)strs.get(dis.readUnsignedShort());
            String descriptor = (String)strs.get(dis.readUnsignedShort());
            int attributes_count = dis.readShort();
            int j = 0;
            while (j < attributes_count) {
                String attrName = (String)strs.get(dis.readUnsignedShort());
                int attribute_length = dis.readInt();
                if ("Code".equals(attrName)) {
                    dis.skipBytes(2);
                    dis.skipBytes(2);
                    int code_len = dis.readInt();
                    dis.skipBytes(code_len);
                    int exception_table_length = dis.readUnsignedShort();
                    dis.skipBytes(8 * exception_table_length);
                    int code_attributes_count = dis.readUnsignedShort();
                    int k = 0;
                    while (k < code_attributes_count) {
                        int str_index = dis.readUnsignedShort();
                        String codeAttrName = (String)strs.get(str_index);
                        int code_attribute_length = dis.readInt();
                        if ("LocalVariableTable".equals(codeAttrName)) {
                            int local_variable_table_length = dis.readUnsignedShort();
                            ArrayList<String> varNames = new ArrayList<String>(local_variable_table_length);
                            int l = 0;
                            while (l < local_variable_table_length) {
                                dis.skipBytes(2);
                                dis.skipBytes(2);
                                String varName = (String)strs.get(dis.readUnsignedShort());
                                dis.skipBytes(2);
                                dis.skipBytes(2);
                                if (!"this".equals(varName)) {
                                    varNames.add(varName);
                                }
                                ++l;
                            }
                            names.put(String.valueOf(methodName) + "," + descriptor, varNames);
                        } else {
                            dis.skipBytes(code_attribute_length);
                        }
                        ++k;
                    }
                } else {
                    dis.skipBytes(attribute_length);
                }
                ++j;
            }
            ++i3;
        }
        dis.close();
        return names;
    }

    public static String getKey(Object obj) {
        StringBuilder sb = new StringBuilder();
        if (obj instanceof Method) {
            sb.append(((Method)obj).getName()).append(',');
            MethodParamNamesScaner.getDescriptor(sb, (Method)obj);
        } else if (obj instanceof Constructor) {
            sb.append("<init>,");
            MethodParamNamesScaner.getDescriptor(sb, (Constructor)obj);
        } else {
            throw new RuntimeException("Not Method or Constructor!");
        }
        return sb.toString();
    }

    public static void getDescriptor(StringBuilder sb, Method method) {
        sb.append('(');
        Class<?>[] classArray = method.getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> klass = classArray[n2];
            MethodParamNamesScaner.getDescriptor(sb, klass);
            ++n2;
        }
        sb.append(')');
        MethodParamNamesScaner.getDescriptor(sb, method.getReturnType());
    }

    public static void getDescriptor(StringBuilder sb, Constructor<?> constructor) {
        sb.append('(');
        Class<?>[] classArray = constructor.getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> klass = classArray[n2];
            MethodParamNamesScaner.getDescriptor(sb, klass);
            ++n2;
        }
        sb.append(')');
        sb.append('V');
    }

    public static void getDescriptor(StringBuilder buf, Class<?> c) {
        Class<?> d = c;
        while (true) {
            if (d.isPrimitive()) {
                int car = d == Integer.TYPE ? 73 : (d == Void.TYPE ? 86 : (d == Boolean.TYPE ? 90 : (d == Byte.TYPE ? 66 : (d == Character.TYPE ? 67 : (d == Short.TYPE ? 83 : (d == Double.TYPE ? 68 : (d == Float.TYPE ? 70 : 74)))))));
                buf.append((char)car);
                return;
            }
            if (!d.isArray()) break;
            buf.append('[');
            d = d.getComponentType();
        }
        buf.append('L');
        String name = d.getName();
        int len = name.length();
        int i = 0;
        while (i < len) {
            char car = name.charAt(i);
            buf.append(car == '.' ? (char)'/' : (char)car);
            ++i;
        }
        buf.append(';');
    }
}

