/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.util;

import org.nutz.castor.Castors;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.lang.util.DateRegion;
import org.nutz.lang.util.DoubleRegion;
import org.nutz.lang.util.FloatRegion;
import org.nutz.lang.util.IntRegion;
import org.nutz.lang.util.LongRegion;

public abstract class Region<T extends Comparable<T>> {
    protected Class<T> eleType = Mirror.getTypeParam(this.getClass(), 0);
    protected T left;
    protected T right;
    protected boolean leftOpen;
    protected boolean rightOpen;

    public static IntRegion Int(String str) {
        return new IntRegion(str);
    }

    public static LongRegion Long(String str) {
        return new LongRegion(str);
    }

    public static FloatRegion Float(String str) {
        return new FloatRegion(str);
    }

    public static DoubleRegion Double(String str) {
        return new DoubleRegion(str);
    }

    public static DateRegion Date(String str) {
        return new DateRegion(str);
    }

    public T left() {
        return this.left;
    }

    public T right() {
        return this.right;
    }

    public boolean isLeftOpen() {
        return this.leftOpen;
    }

    public boolean isRightOpen() {
        return this.rightOpen;
    }

    public boolean isRegion() {
        return this.left != this.right && !this.isNull();
    }

    public boolean isNull() {
        return this.left == null && this.right == null;
    }

    public String leftOpt(String gt, String gte) {
        if (this.left == null) {
            return null;
        }
        return this.leftOpen ? gt : gte;
    }

    public String rightOpt(String lt, String lte) {
        if (this.right == null) {
            return null;
        }
        return this.rightOpen ? lt : lte;
    }

    public boolean match(T obj) {
        int c;
        if (obj == null) {
            return false;
        }
        if (!this.isRegion()) {
            return this.left.compareTo(obj) == 0;
        }
        if (this.left != null && ((c = obj.compareTo(this.left)) < 0 || c == 0 && this.leftOpen)) {
            return false;
        }
        return this.right == null || (c = obj.compareTo(this.right)) <= 0 && (c != 0 || !this.rightOpen);
    }

    public Region<T> valueOf(String str) {
        String[] ss = str.substring(1, str.length() - 1).split(",");
        if (ss.length == 1) {
            this.left = this.fromString(ss[0]);
            this.right = this.left;
        } else {
            this.leftOpen = str.charAt(0) == '(';
            this.rightOpen = str.charAt(str.length() - 1) == ')';
            this.left = this.fromString(ss[0]);
            this.right = this.fromString(ss[1]);
            if (this.left.compareTo(this.right) > 0) {
                T o = this.right;
                this.right = this.left;
                this.left = o;
            }
        }
        return this;
    }

    public String toString(T obj) {
        return obj.toString();
    }

    public T fromString(String str) {
        if (Strings.isEmpty(str = Strings.trim(str))) {
            return null;
        }
        return (T)((Comparable)Castors.me().castTo(str, this.eleType));
    }

    public String toString() {
        if (this.isRegion()) {
            return String.format("%c%s,%s%c", Character.valueOf(this.leftOpen ? (char)'(' : '['), this.toString(this.left), this.toString(this.right), Character.valueOf(this.rightOpen ? (char)')' : ']'));
        }
        return String.format("%c%s%c", Character.valueOf(this.leftOpen ? (char)'(' : '['), this.toString(this.left), Character.valueOf(this.rightOpen ? (char)')' : ']'));
    }
}

