/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.nutz.lang.Each;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.util.Node;

public class SimpleNode<T>
implements Node<T> {
    private T obj;
    private SimpleNode<T> parent;
    private SimpleNode<T> prev;
    private SimpleNode<T> next;
    private SimpleNode<T> firstChild;
    private SimpleNode<T> lastChild;

    @Override
    public T get() {
        return this.obj;
    }

    @Override
    public Node<T> set(T obj) {
        this.obj = obj;
        return this;
    }

    @Override
    public Node<T> parent() {
        return this.parent;
    }

    @Override
    public Node<T> top() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.top();
    }

    @Override
    public Node<T> prev() {
        return this.prev;
    }

    @Override
    public Node<T> prev(Node<T> node) {
        SimpleNode nd;
        this.prev = nd = (SimpleNode)node;
        nd.next = this;
        nd.parent = this.parent;
        return this;
    }

    @Override
    public Node<T> next() {
        return this.next;
    }

    @Override
    public Node<T> next(Node<T> node) {
        SimpleNode nd;
        this.next = nd = (SimpleNode)node;
        nd.prev = this;
        nd.parent = this;
        return this;
    }

    @Override
    public boolean isRoot() {
        return this.parent == null;
    }

    @Override
    public boolean isLast() {
        return this.next == null;
    }

    @Override
    public boolean isFirst() {
        return this.prev == null;
    }

    @Override
    public List<Node<T>> parents() {
        LinkedList<Node<T>> list = new LinkedList<Node<T>>();
        Node<T> me = this.parent;
        while (me != null) {
            list.addFirst(me);
            me = me.parent();
        }
        return list;
    }

    @Override
    public List<Node<T>> getAncestors() {
        LinkedList<Node<T>> list = new LinkedList<Node<T>>();
        Node<T> me = this.parent;
        while (me != null) {
            list.add(me);
            me = me.parent();
        }
        return list;
    }

    @Override
    public int depth() {
        int re = 0;
        Node<T> nd = this;
        while (nd.parent() != null) {
            ++re;
            nd = nd.parent();
        }
        return re;
    }

    @Override
    public List<Node<T>> getNextSibling() {
        LinkedList<Node<T>> list = new LinkedList<Node<T>>();
        Node<T> me = this.next;
        while (me != null) {
            list.add(me);
            me = me.next();
        }
        return list;
    }

    @Override
    public List<Node<T>> getPrevSibling() {
        LinkedList<Node<T>> list = new LinkedList<Node<T>>();
        Node<T> me = this.prev;
        while (me != null) {
            list.add(me);
            me = me.prev();
        }
        return list;
    }

    @Override
    public int index() {
        return this.getPrevSibling().size();
    }

    @Override
    public List<Node<T>> getChildren() {
        LinkedList<Node<T>> list = new LinkedList<Node<T>>();
        if (this.firstChild != null) {
            list.add(this.firstChild);
            list.addAll(this.firstChild.getNextSibling());
        }
        return list;
    }

    @Override
    public int countChildren() {
        int re = 0;
        if (this.firstChild != null) {
            Node<T> me = this.firstChild;
            while (me != null) {
                ++re;
                me = me.next();
            }
        }
        return re;
    }

    @Override
    public boolean hasChild() {
        return this.firstChild != null;
    }

    @Override
    public Node<T> firstChild() {
        return this.firstChild;
    }

    @Override
    public Node<T> lastChild() {
        return this.lastChild;
    }

    @Override
    public Node<T> parent(Node<T> node) {
        this.parent = (SimpleNode)node;
        node.add(this);
        return this;
    }

    @Override
    public Node<T> clearChildren() {
        this.firstChild = null;
        this.lastChild = null;
        return this;
    }

    @Override
    public Node<T> add(Node<?> ... nodes) {
        if (nodes.length == 0) {
            return this;
        }
        if (nodes.length == 1) {
            SimpleNode node = (SimpleNode)nodes[0];
            node.parent = this;
            if (!this.hasChild()) {
                this.firstChild = node;
                this.lastChild = node;
                node.next = null;
                node.prev = null;
            } else {
                this.lastChild.next = node;
                node.prev = this.lastChild;
                node.next = null;
                this.lastChild = node;
            }
        } else {
            SimpleNode theNode = (SimpleNode)nodes[0];
            theNode.parent = this;
            theNode.next = (SimpleNode)nodes[1];
            if (this.lastChild == null) {
                this.firstChild = theNode;
            } else {
                this.lastChild.next = theNode;
            }
            int i = 1;
            while (i < nodes.length - 1) {
                SimpleNode node = (SimpleNode)nodes[i];
                node.parent = this;
                node.prev = (SimpleNode)nodes[i - 1];
                node.next = (SimpleNode)nodes[i + 1];
                ++i;
            }
            this.lastChild = (SimpleNode)nodes[i];
            this.lastChild.parent = this;
            this.lastChild.prev = (SimpleNode)nodes[i - 1];
        }
        return this;
    }

    @Override
    public Node<T> addFirst(Node<T> node) {
        ((SimpleNode)node).parent = this;
        if (!this.hasChild()) {
            this.firstChild = (SimpleNode)node;
            this.lastChild = (SimpleNode)node;
            ((SimpleNode)node).next = null;
            ((SimpleNode)node).prev = null;
        } else {
            this.firstChild.prev = (SimpleNode)node;
            ((SimpleNode)node).next = this.firstChild;
            ((SimpleNode)node).prev = null;
            this.firstChild = (SimpleNode)node;
        }
        return this;
    }

    @Override
    public Node<T> child(int index) {
        if (this.hasChild()) {
            return this.firstChild.next(index);
        }
        return null;
    }

    @Override
    public <E extends Node<T>> void eachChild(Each<E> callback) {
        SimpleNode<T> nd = this.firstChild;
        int i = 0;
        while (nd != null) {
            callback.invoke(i++, nd, -1);
            nd = nd.next;
            if (nd != this.firstChild) continue;
            throw Lang.makeThrow("If i am here, tell me -_-!", new Object[0]);
        }
    }

    @Override
    public Node<T> desc(int ... indexes) {
        Node<T> me = this;
        int[] nArray = indexes;
        int n = indexes.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (!me.hasChild()) {
                return null;
            }
            me = me.firstChild().next(i);
            ++n2;
        }
        return me;
    }

    @Override
    public Node<T> next(int index) {
        if (index < 0) {
            return null;
        }
        Node<T> me = this;
        while (index > 0 && me != null) {
            --index;
            me = me.next();
        }
        if (index > 0) {
            return null;
        }
        return me;
    }

    @Override
    public Node<T> prev(int index) {
        Node<T> me = this;
        while (index > 0 && me != null) {
            --index;
            me = me.prev();
        }
        return me;
    }

    @Override
    public Node<T> insertBefore(int index, Node<T> node) {
        SimpleNode me = (SimpleNode)this.child(index);
        if (me != null) {
            ((SimpleNode)node).next = me;
            ((SimpleNode)node).prev = me.prev;
            me.prev.next = (SimpleNode)node;
            me.prev = (SimpleNode)node;
            ((SimpleNode)node).parent = this;
            if (this.firstChild == me) {
                this.firstChild = (SimpleNode)node;
            }
        }
        return this;
    }

    @Override
    public Node<T> pop() {
        if (!this.hasChild()) {
            return null;
        }
        SimpleNode<T> re = this.lastChild;
        this.lastChild = this.lastChild.prev;
        if (this.lastChild == null) {
            this.firstChild = null;
        } else {
            this.lastChild.next = null;
        }
        re.prev = null;
        re.next = null;
        return re;
    }

    @Override
    public Node<T> popFirst() {
        if (!this.hasChild()) {
            return null;
        }
        SimpleNode<T> re = this.firstChild;
        this.firstChild = this.firstChild.next;
        if (this.firstChild == null) {
            this.lastChild = null;
        } else {
            this.firstChild.prev = null;
        }
        re.prev = null;
        re.next = null;
        return re;
    }

    @Override
    public Node<T> removeChild(int index) {
        if (this.hasChild()) {
            SimpleNode node = (SimpleNode)this.child(index);
            if (node == null) {
                return null;
            }
            if (node.isLast()) {
                return this.pop();
            }
            if (node.isFirst()) {
                return this.popFirst();
            }
            node.next.prev = node.prev;
            node.prev.next = node.next;
            node.prev = null;
            node.next = null;
            return node;
        }
        return null;
    }

    @Override
    public boolean remove() {
        int i = this.getIndex();
        if (i < 0) {
            return false;
        }
        this.parent.removeChild(i);
        return true;
    }

    @Override
    public int getIndex() {
        if (this.parent == null) {
            return -1;
        }
        int i = 0;
        Node<T> n = this.parent.firstChild();
        while (n != this.parent.child(i)) {
            ++i;
        }
        return i;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        SimpleNode.appendTo(this, sb, 0);
        return sb.toString();
    }

    static void appendTo(Node<?> node, StringBuilder sb, int depth) {
        sb.append(Strings.dup("    ", depth)).append(node.get() == null ? "NULL" : node.get().toString());
        Node<?> chd = node.firstChild();
        while (chd != null) {
            sb.append('\n');
            SimpleNode.appendTo(chd, sb, depth + 1);
            chd = chd.next();
        }
    }

    @Override
    public Iterator<Node<T>> iterator() {
        return new InnerIterator(this);
    }

    static class InnerIterator<T>
    implements Iterator<Node<T>> {
        private Node<T> root;
        private Node<T> node;

        InnerIterator(Node<T> node) {
            this.root = node;
            this.node = this.root.hasChild() ? this.root.child(0) : this.root;
        }

        @Override
        public boolean hasNext() {
            return this.node != this.root;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public Node<T> next() {
            block4: {
                block3: {
                    if (this.node == this.root) {
                        return null;
                    }
                    re = this.node;
                    if (!this.node.hasChild()) break block3;
                    this.node = this.node.firstChild();
                    break block4;
                }
                if (this.node.isLast()) ** GOTO lbl12
                this.node = this.node.next();
                break block4;
lbl-1000:
                // 1 sources

                {
                    this.node = this.node.parent();
lbl12:
                    // 2 sources

                    ** while (this.node.isLast() && !this.node.isRoot())
                }
lbl13:
                // 1 sources

                if (!this.node.isRoot()) {
                    this.node = this.node.next();
                }
            }
            return re;
        }

        @Override
        public void remove() {
            throw Lang.makeThrow("No implement yet!", new Object[0]);
        }
    }
}

