/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.log;

import org.nutz.lang.Lang;
import org.nutz.log.Log;
import org.nutz.log.LogAdapter;
import org.nutz.log.impl.NopLog;
import org.nutz.plugin.SimplePluginManager;

public final class Logs {
    private static LogAdapter adapter;
    public static LogAdapter NOP_ADAPTER;

    static {
        Logs.init();
        try {
            Logs.get().info("Nutz is licensed under the Apache License, Version 2.0 .\nReport bugs : https://github.com/nutzam/nutz/issues");
        }
        catch (Throwable throwable) {}
        NOP_ADAPTER = NopLog.NOP;
    }

    public static Log getLog(Class<?> clazz) {
        return Logs.getLog(clazz.getName());
    }

    public static Log getLog(String className) {
        return adapter.getLogger(className);
    }

    public static Log get() {
        StackTraceElement[] sts = Thread.currentThread().getStackTrace();
        if (Lang.isAndroid) {
            int i = 0;
            while (i < sts.length) {
                if (sts[i].getClassName().equals(Logs.class.getName())) {
                    return adapter.getLogger(sts[i + 1].getClassName());
                }
                ++i;
            }
        }
        return adapter.getLogger(sts[2].getClassName());
    }

    public static void init() {
        try {
            String packageName = String.valueOf(Logs.class.getPackage().getName()) + ".impl.";
            adapter = (LogAdapter)new SimplePluginManager(String.valueOf(packageName) + "Log4jLogAdapter", String.valueOf(packageName) + "SystemLogAdapter").get();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void setAdapter(LogAdapter adapter) {
        Logs.adapter = adapter;
    }
}

