/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mapl.impl.compile;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nutz.json.Json;
import org.nutz.json.entity.JsonEntity;
import org.nutz.json.entity.JsonEntityField;
import org.nutz.lang.FailToGetValueException;
import org.nutz.lang.Mirror;
import org.nutz.mapl.MaplCompile;

public class ObjCompileImpl
implements MaplCompile<Object> {
    private Map<Object, Object> memo = new HashMap<Object, Object>();

    @Override
    public Object parse(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ObjCompileImpl) {
            return ((ObjCompileImpl)obj).parse((Object)null);
        }
        if (obj instanceof Class) {
            return obj;
        }
        if (obj instanceof Mirror) {
            return ((Mirror)obj).getType().getName();
        }
        Mirror<Class<?>> mr = Mirror.me(obj.getClass());
        if (mr.isEnum()) {
            return obj;
        }
        if (mr.isNumber() || mr.isBoolean()) {
            return obj;
        }
        if (mr.isStringLike() || mr.isChar()) {
            return obj;
        }
        if (mr.isDateTimeLike()) {
            return obj;
        }
        if (this.memo.containsKey(obj)) {
            return this.memo.get(obj);
        }
        if (obj instanceof Collection || obj.getClass().isArray()) {
            ArrayList<Object> list = new ArrayList<Object>();
            this.memo.put(obj, list);
            if (obj instanceof Collection) {
                return this.coll2Json((Collection)obj, list);
            }
            return this.array2Json(obj, list);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.memo.put(obj, map);
        if (obj instanceof Map) {
            return this.map2Json((Map)obj, map);
        }
        return this.pojo2Json(obj, map);
    }

    private Map<String, Object> map2Json(Map map, Map<String, Object> valMap) {
        if (map == null) {
            return null;
        }
        ArrayList<Pair> list = new ArrayList<Pair>(map.size());
        Set entrySet = map.entrySet();
        for (Map.Entry entry : entrySet) {
            String name = entry.getKey() == null ? "null" : entry.getKey().toString();
            Object value = entry.getValue();
            list.add(new Pair(name, value));
        }
        return this.writeItem(list, valMap);
    }

    private Map<String, Object> pojo2Json(Object obj, Map<String, Object> map) {
        if (obj == null) {
            return null;
        }
        Class<?> type = obj.getClass();
        JsonEntity jen = Json.getEntity(Mirror.me(type));
        List<JsonEntityField> fields = jen.getFields();
        ArrayList<Pair> list = new ArrayList<Pair>(fields.size());
        for (JsonEntityField jef : fields) {
            String name = jef.getName();
            try {
                Mirror<Object> mirror;
                Object value = jef.getValue(obj);
                if (value != null && (mirror = Mirror.me(value)).isPojo()) {
                    value = this.parse(value);
                }
                list.add(new Pair(name, value));
            }
            catch (FailToGetValueException failToGetValueException) {}
        }
        return this.writeItem(list, map);
    }

    private Map<String, Object> writeItem(List<Pair> list, Map<String, Object> map) {
        for (Pair p : list) {
            map.put(p.name, p.value);
        }
        return map;
    }

    private List<Object> array2Json(Object obj, List<Object> list) {
        int len = Array.getLength(obj);
        int i = 0;
        while (i < len) {
            list.add(this.parse(Array.get(obj, i)));
            ++i;
        }
        return list;
    }

    private List<Object> coll2Json(Collection iterable, List<Object> list) {
        Iterator it = iterable.iterator();
        while (it.hasNext()) {
            list.add(this.parse(it.next()));
        }
        return list;
    }

    static class Pair {
        String name;
        Object value;

        public Pair(String name, Object value) {
            this.name = name;
            this.value = value;
        }
    }
}

