/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mapl.impl.convert;

import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nutz.json.Json;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;
import org.nutz.mapl.MaplConvert;
import org.nutz.mapl.impl.MaplEach;
import org.nutz.mapl.impl.MaplRebuild;

public class StructureConvert
extends MaplEach
implements MaplConvert {
    private Map<String, List<String>> relation = new HashMap<String, List<String>>();
    private MaplRebuild structure = new MaplRebuild();

    public StructureConvert(String path) {
        Object obj = Json.fromJson(Streams.fileInr(path));
        this.loadRelation(obj, "");
    }

    public StructureConvert(Reader reader) {
        Object obj = Json.fromJson(reader);
        this.loadRelation(obj, "");
    }

    public StructureConvert(Object obj) {
        this.loadRelation(obj, "");
    }

    @Override
    public Object convert(Object obj) {
        this.each(obj);
        return this.structure.fetchNewobj();
    }

    @Override
    protected void LRD(String path, Object item) {
    }

    @Override
    protected void DLR(String path, Object object) {
        if (this.relation.containsKey(path)) {
            List<String> dests = this.relation.get(path);
            for (String dest : dests) {
                if (dest.equals("")) {
                    this.structure.put(path, object, this.arrayIndex);
                    continue;
                }
                this.structure.put(dest, object, this.arrayIndex);
            }
        }
    }

    private void loadRelation(Object obj, String path) {
        if (obj instanceof Map) {
            this.loadMapRelation((Map)obj, path);
        } else if (obj instanceof List) {
            this.loadListRelation((List)obj, path);
        } else {
            throw new RuntimeException("\u65e0\u6cd5\u8bc6\u522b\u7684\u7c7b\u578b!");
        }
    }

    private void loadListRelation(List<?> obj, String path) {
        if (obj.size() <= 0) {
            return;
        }
        if (obj.get(0) instanceof String) {
            this.relation.put(path, obj);
            return;
        }
        this.loadRelation(obj.get(0), String.valueOf(path) + "[]");
    }

    private void loadMapRelation(Map<?, ?> obj, String path) {
        for (Object key : obj.keySet()) {
            Object val = obj.get(key);
            if (val instanceof String) {
                this.relation.put(String.valueOf(path) + this.space(path) + key.toString(), Lang.list(val.toString()));
                continue;
            }
            this.loadRelation(obj.get(key), String.valueOf(path) + this.space(path) + key.toString());
        }
    }

    private String space(String path) {
        return "".equals(path) ? "" : ".";
    }
}

