/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nutz.lang.Strings;
import org.nutz.lang.util.Context;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.ActionHandler;
import org.nutz.mvc.Mvcs;
import org.nutz.mvc.NutFilter2;
import org.nutz.mvc.RequestPath;
import org.nutz.mvc.SessionProvider;
import org.nutz.mvc.config.FilterNutConfig;

public class NutFilter
implements Filter {
    private static final Log log = Logs.get();
    protected ActionHandler handler;
    private static final String IGNORE = "^.+\\.(jsp|png|gif|jpg|js|css|jspx|jpeg|swf|ico)$";
    private Pattern ignorePtn;
    private String selfName;
    private SessionProvider sp;
    private NutFilter2 proxyFilter;

    public void init(FilterConfig conf) throws ServletException {
        if ("true".equals(Strings.sNull(conf.getInitParameter("skip-mode"), "false").toLowerCase())) {
            log.infof("NutFilter[%s] run as skip-mode", conf.getFilterName());
            this.proxyFilter = new NutFilter2();
            return;
        }
        log.infof("NutFilter[%s] starting ...", conf.getFilterName());
        Mvcs.setServletContext(conf.getServletContext());
        this.selfName = conf.getFilterName();
        Mvcs.set(this.selfName, null, null);
        FilterNutConfig config = new FilterNutConfig(conf);
        Mvcs.setNutConfig(config);
        this.handler = new ActionHandler(config);
        String regx = Strings.sNull(config.getInitParameter("ignore"), IGNORE);
        if (!"null".equalsIgnoreCase(regx)) {
            this.ignorePtn = Pattern.compile(regx, 2);
        }
        this.sp = config.getSessionProvider();
    }

    public void destroy() {
        if (this.proxyFilter != null) {
            return;
        }
        Mvcs.resetALL();
        Mvcs.set(this.selfName, null, null);
        if (this.handler != null) {
            this.handler.depose();
        }
        Mvcs.setServletContext(null);
        Mvcs.close();
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        if (this.proxyFilter != null) {
            this.proxyFilter.doFilter(req, resp, chain);
            return;
        }
        String preName = Mvcs.getName();
        Context preContext = Mvcs.resetALL();
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        try {
            if (this.sp != null) {
                req = this.sp.filter(request, response, Mvcs.getServletContext());
            }
            Mvcs.set(this.selfName, request, response);
            RequestPath path = Mvcs.getRequestPathObject(request);
            if ((this.ignorePtn == null || !this.ignorePtn.matcher(path.getUrl()).find()) && this.handler.handle(request, response)) {
                return;
            }
            Mvcs.updateRequestAttributes((HttpServletRequest)req);
            chain.doFilter(req, resp);
        }
        finally {
            Mvcs.resetALL();
            if (request.getAttribute("javax.servlet.forward.request_uri") != null) {
                if (preName != null) {
                    Mvcs.set(preName, request, response);
                }
                if (preContext != null) {
                    Mvcs.ctx.reqThreadLocal.set(preContext);
                }
            }
        }
    }
}

